package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.KmsKeyId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyEbsDefaultKmsKeyIdRequest(kmsKeyId: KmsKeyId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdRequest = {
    import ModifyEbsDefaultKmsKeyIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdRequest
      .builder()
      .kmsKeyId(KmsKeyId.unwrap(kmsKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdRequest.ReadOnly =
    zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdRequest.wrap(buildAwsValue())
}
object ModifyEbsDefaultKmsKeyIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdRequest =
      zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdRequest(kmsKeyId)
    def kmsKeyId: KmsKeyId
    def getKmsKeyId: ZIO[Any, Nothing, KmsKeyId] = ZIO.succeed(kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdRequest
  ) extends zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdRequest.ReadOnly {
    override val kmsKeyId: KmsKeyId =
      zio.aws.ec2.model.primitives.KmsKeyId(impl.kmsKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyEbsDefaultKmsKeyIdRequest
  ): zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdRequest.ReadOnly = new Wrapper(
    impl
  )
}
