package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDefaultCreditSpecificationResponse(
    instanceFamilyCreditSpecification: Optional[
      zio.aws.ec2.model.InstanceFamilyCreditSpecification
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationResponse = {
    import ModifyDefaultCreditSpecificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationResponse
      .builder()
      .optionallyWith(
        instanceFamilyCreditSpecification.map(value => value.buildAwsValue())
      )(_.instanceFamilyCreditSpecification)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyDefaultCreditSpecificationResponse.ReadOnly =
    zio.aws.ec2.model.ModifyDefaultCreditSpecificationResponse
      .wrap(buildAwsValue())
}
object ModifyDefaultCreditSpecificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyDefaultCreditSpecificationResponse =
      zio.aws.ec2.model.ModifyDefaultCreditSpecificationResponse(
        instanceFamilyCreditSpecification.map(value => value.asEditable)
      )
    def instanceFamilyCreditSpecification
        : Optional[zio.aws.ec2.model.InstanceFamilyCreditSpecification.ReadOnly]
    def getInstanceFamilyCreditSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceFamilyCreditSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceFamilyCreditSpecification",
      instanceFamilyCreditSpecification
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationResponse
  ) extends zio.aws.ec2.model.ModifyDefaultCreditSpecificationResponse.ReadOnly {
    override val instanceFamilyCreditSpecification: Optional[
      zio.aws.ec2.model.InstanceFamilyCreditSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceFamilyCreditSpecification())
      .map(value =>
        zio.aws.ec2.model.InstanceFamilyCreditSpecification.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyDefaultCreditSpecificationResponse
  ): zio.aws.ec2.model.ModifyDefaultCreditSpecificationResponse.ReadOnly =
    new Wrapper(impl)
}
