package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamResourceType {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamResourceType
}
object IpamResourceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamResourceType
  ): zio.aws.ec2.model.IpamResourceType = value match {
    case software.amazon.awssdk.services.ec2.model.IpamResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceType.VPC =>
      val r = vpc
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceType.SUBNET =>
      val r = subnet
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceType.EIP =>
      val r = eip
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceType.PUBLIC_IPV4_POOL =>
      val r = `public-ipv4-pool`
      r
    case software.amazon.awssdk.services.ec2.model.IpamResourceType.IPV6_POOL =>
      val r = `ipv6-pool`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.IpamResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceType =
      software.amazon.awssdk.services.ec2.model.IpamResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object vpc extends zio.aws.ec2.model.IpamResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceType =
      software.amazon.awssdk.services.ec2.model.IpamResourceType.VPC
  }
  case object subnet extends zio.aws.ec2.model.IpamResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceType =
      software.amazon.awssdk.services.ec2.model.IpamResourceType.SUBNET
  }
  case object eip extends zio.aws.ec2.model.IpamResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceType =
      software.amazon.awssdk.services.ec2.model.IpamResourceType.EIP
  }
  case object `public-ipv4-pool` extends zio.aws.ec2.model.IpamResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceType =
      software.amazon.awssdk.services.ec2.model.IpamResourceType.PUBLIC_IPV4_POOL
  }
  case object `ipv6-pool` extends zio.aws.ec2.model.IpamResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamResourceType =
      software.amazon.awssdk.services.ec2.model.IpamResourceType.IPV6_POOL
  }
}
