package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  AllowedInstanceType,
  Integer,
  ExcludedInstanceType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceRequirements(
    vCpuCount: Optional[zio.aws.ec2.model.VCpuCountRange] = Optional.Absent,
    memoryMiB: Optional[zio.aws.ec2.model.MemoryMiB] = Optional.Absent,
    cpuManufacturers: Optional[Iterable[zio.aws.ec2.model.CpuManufacturer]] =
      Optional.Absent,
    memoryGiBPerVCpu: Optional[zio.aws.ec2.model.MemoryGiBPerVCpu] =
      Optional.Absent,
    excludedInstanceTypes: Optional[Iterable[ExcludedInstanceType]] =
      Optional.Absent,
    instanceGenerations: Optional[
      Iterable[zio.aws.ec2.model.InstanceGeneration]
    ] = Optional.Absent,
    spotMaxPricePercentageOverLowestPrice: Optional[Integer] = Optional.Absent,
    onDemandMaxPricePercentageOverLowestPrice: Optional[Integer] =
      Optional.Absent,
    bareMetal: Optional[zio.aws.ec2.model.BareMetal] = Optional.Absent,
    burstablePerformance: Optional[zio.aws.ec2.model.BurstablePerformance] =
      Optional.Absent,
    requireHibernateSupport: Optional[Boolean] = Optional.Absent,
    networkInterfaceCount: Optional[zio.aws.ec2.model.NetworkInterfaceCount] =
      Optional.Absent,
    localStorage: Optional[zio.aws.ec2.model.LocalStorage] = Optional.Absent,
    localStorageTypes: Optional[Iterable[zio.aws.ec2.model.LocalStorageType]] =
      Optional.Absent,
    totalLocalStorageGB: Optional[zio.aws.ec2.model.TotalLocalStorageGB] =
      Optional.Absent,
    baselineEbsBandwidthMbps: Optional[
      zio.aws.ec2.model.BaselineEbsBandwidthMbps
    ] = Optional.Absent,
    acceleratorTypes: Optional[Iterable[zio.aws.ec2.model.AcceleratorType]] =
      Optional.Absent,
    acceleratorCount: Optional[zio.aws.ec2.model.AcceleratorCount] =
      Optional.Absent,
    acceleratorManufacturers: Optional[
      Iterable[zio.aws.ec2.model.AcceleratorManufacturer]
    ] = Optional.Absent,
    acceleratorNames: Optional[Iterable[zio.aws.ec2.model.AcceleratorName]] =
      Optional.Absent,
    acceleratorTotalMemoryMiB: Optional[
      zio.aws.ec2.model.AcceleratorTotalMemoryMiB
    ] = Optional.Absent,
    networkBandwidthGbps: Optional[zio.aws.ec2.model.NetworkBandwidthGbps] =
      Optional.Absent,
    allowedInstanceTypes: Optional[Iterable[AllowedInstanceType]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceRequirements = {
    import InstanceRequirements.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceRequirements
      .builder()
      .optionallyWith(vCpuCount.map(value => value.buildAwsValue()))(
        _.vCpuCount
      )
      .optionallyWith(memoryMiB.map(value => value.buildAwsValue()))(
        _.memoryMiB
      )
      .optionallyWith(
        cpuManufacturers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.cpuManufacturersWithStrings)
      .optionallyWith(memoryGiBPerVCpu.map(value => value.buildAwsValue()))(
        _.memoryGiBPerVCpu
      )
      .optionallyWith(
        excludedInstanceTypes.map(value =>
          value.map { item =>
            ExcludedInstanceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedInstanceTypes)
      .optionallyWith(
        instanceGenerations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.instanceGenerationsWithStrings)
      .optionallyWith(
        spotMaxPricePercentageOverLowestPrice.map(value =>
          value: java.lang.Integer
        )
      )(_.spotMaxPricePercentageOverLowestPrice)
      .optionallyWith(
        onDemandMaxPricePercentageOverLowestPrice.map(value =>
          value: java.lang.Integer
        )
      )(_.onDemandMaxPricePercentageOverLowestPrice)
      .optionallyWith(bareMetal.map(value => value.unwrap))(_.bareMetal)
      .optionallyWith(burstablePerformance.map(value => value.unwrap))(
        _.burstablePerformance
      )
      .optionallyWith(
        requireHibernateSupport.map(value => value: java.lang.Boolean)
      )(_.requireHibernateSupport)
      .optionallyWith(
        networkInterfaceCount.map(value => value.buildAwsValue())
      )(_.networkInterfaceCount)
      .optionallyWith(localStorage.map(value => value.unwrap))(_.localStorage)
      .optionallyWith(
        localStorageTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.localStorageTypesWithStrings)
      .optionallyWith(totalLocalStorageGB.map(value => value.buildAwsValue()))(
        _.totalLocalStorageGB
      )
      .optionallyWith(
        baselineEbsBandwidthMbps.map(value => value.buildAwsValue())
      )(_.baselineEbsBandwidthMbps)
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorTypesWithStrings)
      .optionallyWith(acceleratorCount.map(value => value.buildAwsValue()))(
        _.acceleratorCount
      )
      .optionallyWith(
        acceleratorManufacturers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorManufacturersWithStrings)
      .optionallyWith(
        acceleratorNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.acceleratorNamesWithStrings)
      .optionallyWith(
        acceleratorTotalMemoryMiB.map(value => value.buildAwsValue())
      )(_.acceleratorTotalMemoryMiB)
      .optionallyWith(networkBandwidthGbps.map(value => value.buildAwsValue()))(
        _.networkBandwidthGbps
      )
      .optionallyWith(
        allowedInstanceTypes.map(value =>
          value.map { item =>
            AllowedInstanceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.allowedInstanceTypes)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceRequirements.ReadOnly =
    zio.aws.ec2.model.InstanceRequirements.wrap(buildAwsValue())
}
object InstanceRequirements {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceRequirements
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceRequirements =
      zio.aws.ec2.model.InstanceRequirements(
        vCpuCount.map(value => value.asEditable),
        memoryMiB.map(value => value.asEditable),
        cpuManufacturers.map(value => value),
        memoryGiBPerVCpu.map(value => value.asEditable),
        excludedInstanceTypes.map(value => value),
        instanceGenerations.map(value => value),
        spotMaxPricePercentageOverLowestPrice.map(value => value),
        onDemandMaxPricePercentageOverLowestPrice.map(value => value),
        bareMetal.map(value => value),
        burstablePerformance.map(value => value),
        requireHibernateSupport.map(value => value),
        networkInterfaceCount.map(value => value.asEditable),
        localStorage.map(value => value),
        localStorageTypes.map(value => value),
        totalLocalStorageGB.map(value => value.asEditable),
        baselineEbsBandwidthMbps.map(value => value.asEditable),
        acceleratorTypes.map(value => value),
        acceleratorCount.map(value => value.asEditable),
        acceleratorManufacturers.map(value => value),
        acceleratorNames.map(value => value),
        acceleratorTotalMemoryMiB.map(value => value.asEditable),
        networkBandwidthGbps.map(value => value.asEditable),
        allowedInstanceTypes.map(value => value)
      )
    def vCpuCount: Optional[zio.aws.ec2.model.VCpuCountRange.ReadOnly]
    def memoryMiB: Optional[zio.aws.ec2.model.MemoryMiB.ReadOnly]
    def cpuManufacturers: Optional[List[zio.aws.ec2.model.CpuManufacturer]]
    def memoryGiBPerVCpu: Optional[zio.aws.ec2.model.MemoryGiBPerVCpu.ReadOnly]
    def excludedInstanceTypes: Optional[List[ExcludedInstanceType]]
    def instanceGenerations
        : Optional[List[zio.aws.ec2.model.InstanceGeneration]]
    def spotMaxPricePercentageOverLowestPrice: Optional[Integer]
    def onDemandMaxPricePercentageOverLowestPrice: Optional[Integer]
    def bareMetal: Optional[zio.aws.ec2.model.BareMetal]
    def burstablePerformance: Optional[zio.aws.ec2.model.BurstablePerformance]
    def requireHibernateSupport: Optional[Boolean]
    def networkInterfaceCount
        : Optional[zio.aws.ec2.model.NetworkInterfaceCount.ReadOnly]
    def localStorage: Optional[zio.aws.ec2.model.LocalStorage]
    def localStorageTypes: Optional[List[zio.aws.ec2.model.LocalStorageType]]
    def totalLocalStorageGB
        : Optional[zio.aws.ec2.model.TotalLocalStorageGB.ReadOnly]
    def baselineEbsBandwidthMbps
        : Optional[zio.aws.ec2.model.BaselineEbsBandwidthMbps.ReadOnly]
    def acceleratorTypes: Optional[List[zio.aws.ec2.model.AcceleratorType]]
    def acceleratorCount: Optional[zio.aws.ec2.model.AcceleratorCount.ReadOnly]
    def acceleratorManufacturers
        : Optional[List[zio.aws.ec2.model.AcceleratorManufacturer]]
    def acceleratorNames: Optional[List[zio.aws.ec2.model.AcceleratorName]]
    def acceleratorTotalMemoryMiB
        : Optional[zio.aws.ec2.model.AcceleratorTotalMemoryMiB.ReadOnly]
    def networkBandwidthGbps
        : Optional[zio.aws.ec2.model.NetworkBandwidthGbps.ReadOnly]
    def allowedInstanceTypes: Optional[List[AllowedInstanceType]]
    def getVCpuCount
        : ZIO[Any, AwsError, zio.aws.ec2.model.VCpuCountRange.ReadOnly] =
      AwsError.unwrapOptionField("vCpuCount", vCpuCount)
    def getMemoryMiB: ZIO[Any, AwsError, zio.aws.ec2.model.MemoryMiB.ReadOnly] =
      AwsError.unwrapOptionField("memoryMiB", memoryMiB)
    def getCpuManufacturers
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.CpuManufacturer]] =
      AwsError.unwrapOptionField("cpuManufacturers", cpuManufacturers)
    def getMemoryGiBPerVCpu
        : ZIO[Any, AwsError, zio.aws.ec2.model.MemoryGiBPerVCpu.ReadOnly] =
      AwsError.unwrapOptionField("memoryGiBPerVCpu", memoryGiBPerVCpu)
    def getExcludedInstanceTypes
        : ZIO[Any, AwsError, List[ExcludedInstanceType]] =
      AwsError.unwrapOptionField("excludedInstanceTypes", excludedInstanceTypes)
    def getInstanceGenerations
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.InstanceGeneration]] =
      AwsError.unwrapOptionField("instanceGenerations", instanceGenerations)
    def getSpotMaxPricePercentageOverLowestPrice: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "spotMaxPricePercentageOverLowestPrice",
        spotMaxPricePercentageOverLowestPrice
      )
    def getOnDemandMaxPricePercentageOverLowestPrice
        : ZIO[Any, AwsError, Integer] = AwsError.unwrapOptionField(
      "onDemandMaxPricePercentageOverLowestPrice",
      onDemandMaxPricePercentageOverLowestPrice
    )
    def getBareMetal: ZIO[Any, AwsError, zio.aws.ec2.model.BareMetal] =
      AwsError.unwrapOptionField("bareMetal", bareMetal)
    def getBurstablePerformance
        : ZIO[Any, AwsError, zio.aws.ec2.model.BurstablePerformance] =
      AwsError.unwrapOptionField("burstablePerformance", burstablePerformance)
    def getRequireHibernateSupport: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("requireHibernateSupport", requireHibernateSupport)
    def getNetworkInterfaceCount
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkInterfaceCount.ReadOnly] =
      AwsError.unwrapOptionField("networkInterfaceCount", networkInterfaceCount)
    def getLocalStorage: ZIO[Any, AwsError, zio.aws.ec2.model.LocalStorage] =
      AwsError.unwrapOptionField("localStorage", localStorage)
    def getLocalStorageTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.LocalStorageType]] =
      AwsError.unwrapOptionField("localStorageTypes", localStorageTypes)
    def getTotalLocalStorageGB
        : ZIO[Any, AwsError, zio.aws.ec2.model.TotalLocalStorageGB.ReadOnly] =
      AwsError.unwrapOptionField("totalLocalStorageGB", totalLocalStorageGB)
    def getBaselineEbsBandwidthMbps: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.BaselineEbsBandwidthMbps.ReadOnly
    ] = AwsError.unwrapOptionField(
      "baselineEbsBandwidthMbps",
      baselineEbsBandwidthMbps
    )
    def getAcceleratorTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AcceleratorType]] =
      AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
    def getAcceleratorCount
        : ZIO[Any, AwsError, zio.aws.ec2.model.AcceleratorCount.ReadOnly] =
      AwsError.unwrapOptionField("acceleratorCount", acceleratorCount)
    def getAcceleratorManufacturers
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AcceleratorManufacturer]] =
      AwsError.unwrapOptionField(
        "acceleratorManufacturers",
        acceleratorManufacturers
      )
    def getAcceleratorNames
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AcceleratorName]] =
      AwsError.unwrapOptionField("acceleratorNames", acceleratorNames)
    def getAcceleratorTotalMemoryMiB: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AcceleratorTotalMemoryMiB.ReadOnly
    ] = AwsError.unwrapOptionField(
      "acceleratorTotalMemoryMiB",
      acceleratorTotalMemoryMiB
    )
    def getNetworkBandwidthGbps
        : ZIO[Any, AwsError, zio.aws.ec2.model.NetworkBandwidthGbps.ReadOnly] =
      AwsError.unwrapOptionField("networkBandwidthGbps", networkBandwidthGbps)
    def getAllowedInstanceTypes: ZIO[Any, AwsError, List[AllowedInstanceType]] =
      AwsError.unwrapOptionField("allowedInstanceTypes", allowedInstanceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceRequirements
  ) extends zio.aws.ec2.model.InstanceRequirements.ReadOnly {
    override val vCpuCount
        : Optional[zio.aws.ec2.model.VCpuCountRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vCpuCount())
        .map(value => zio.aws.ec2.model.VCpuCountRange.wrap(value))
    override val memoryMiB: Optional[zio.aws.ec2.model.MemoryMiB.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memoryMiB())
        .map(value => zio.aws.ec2.model.MemoryMiB.wrap(value))
    override val cpuManufacturers
        : Optional[List[zio.aws.ec2.model.CpuManufacturer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cpuManufacturers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CpuManufacturer.wrap(item)
          }.toList
        )
    override val memoryGiBPerVCpu
        : Optional[zio.aws.ec2.model.MemoryGiBPerVCpu.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memoryGiBPerVCpu())
        .map(value => zio.aws.ec2.model.MemoryGiBPerVCpu.wrap(value))
    override val excludedInstanceTypes: Optional[List[ExcludedInstanceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludedInstanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ExcludedInstanceType(item)
          }.toList
        )
    override val instanceGenerations
        : Optional[List[zio.aws.ec2.model.InstanceGeneration]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceGenerations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceGeneration.wrap(item)
          }.toList
        )
    override val spotMaxPricePercentageOverLowestPrice: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spotMaxPricePercentageOverLowestPrice())
        .map(value => value: Integer)
    override val onDemandMaxPricePercentageOverLowestPrice: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onDemandMaxPricePercentageOverLowestPrice())
        .map(value => value: Integer)
    override val bareMetal: Optional[zio.aws.ec2.model.BareMetal] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bareMetal())
        .map(value => zio.aws.ec2.model.BareMetal.wrap(value))
    override val burstablePerformance
        : Optional[zio.aws.ec2.model.BurstablePerformance] =
      zio.aws.core.internal
        .optionalFromNullable(impl.burstablePerformance())
        .map(value => zio.aws.ec2.model.BurstablePerformance.wrap(value))
    override val requireHibernateSupport: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requireHibernateSupport())
        .map(value => value: Boolean)
    override val networkInterfaceCount
        : Optional[zio.aws.ec2.model.NetworkInterfaceCount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceCount())
        .map(value => zio.aws.ec2.model.NetworkInterfaceCount.wrap(value))
    override val localStorage: Optional[zio.aws.ec2.model.LocalStorage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localStorage())
        .map(value => zio.aws.ec2.model.LocalStorage.wrap(value))
    override val localStorageTypes
        : Optional[List[zio.aws.ec2.model.LocalStorageType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localStorageTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LocalStorageType.wrap(item)
          }.toList
        )
    override val totalLocalStorageGB
        : Optional[zio.aws.ec2.model.TotalLocalStorageGB.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalLocalStorageGB())
        .map(value => zio.aws.ec2.model.TotalLocalStorageGB.wrap(value))
    override val baselineEbsBandwidthMbps
        : Optional[zio.aws.ec2.model.BaselineEbsBandwidthMbps.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baselineEbsBandwidthMbps())
        .map(value => zio.aws.ec2.model.BaselineEbsBandwidthMbps.wrap(value))
    override val acceleratorTypes
        : Optional[List[zio.aws.ec2.model.AcceleratorType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AcceleratorType.wrap(item)
          }.toList
        )
    override val acceleratorCount
        : Optional[zio.aws.ec2.model.AcceleratorCount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorCount())
        .map(value => zio.aws.ec2.model.AcceleratorCount.wrap(value))
    override val acceleratorManufacturers
        : Optional[List[zio.aws.ec2.model.AcceleratorManufacturer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorManufacturers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AcceleratorManufacturer.wrap(item)
          }.toList
        )
    override val acceleratorNames
        : Optional[List[zio.aws.ec2.model.AcceleratorName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AcceleratorName.wrap(item)
          }.toList
        )
    override val acceleratorTotalMemoryMiB
        : Optional[zio.aws.ec2.model.AcceleratorTotalMemoryMiB.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorTotalMemoryMiB())
        .map(value => zio.aws.ec2.model.AcceleratorTotalMemoryMiB.wrap(value))
    override val networkBandwidthGbps
        : Optional[zio.aws.ec2.model.NetworkBandwidthGbps.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkBandwidthGbps())
        .map(value => zio.aws.ec2.model.NetworkBandwidthGbps.wrap(value))
    override val allowedInstanceTypes: Optional[List[AllowedInstanceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowedInstanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.AllowedInstanceType(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceRequirements
  ): zio.aws.ec2.model.InstanceRequirements.ReadOnly = new Wrapper(impl)
}
