package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportToS3TaskSpecification(
    containerFormat: Optional[zio.aws.ec2.model.ContainerFormat] =
      Optional.Absent,
    diskImageFormat: Optional[zio.aws.ec2.model.DiskImageFormat] =
      Optional.Absent,
    s3Bucket: Optional[String] = Optional.Absent,
    s3Prefix: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ExportToS3TaskSpecification = {
    import ExportToS3TaskSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportToS3TaskSpecification
      .builder()
      .optionallyWith(containerFormat.map(value => value.unwrap))(
        _.containerFormat
      )
      .optionallyWith(diskImageFormat.map(value => value.unwrap))(
        _.diskImageFormat
      )
      .optionallyWith(s3Bucket.map(value => value: java.lang.String))(
        _.s3Bucket
      )
      .optionallyWith(s3Prefix.map(value => value: java.lang.String))(
        _.s3Prefix
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ExportToS3TaskSpecification.ReadOnly =
    zio.aws.ec2.model.ExportToS3TaskSpecification.wrap(buildAwsValue())
}
object ExportToS3TaskSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ExportToS3TaskSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ExportToS3TaskSpecification =
      zio.aws.ec2.model.ExportToS3TaskSpecification(
        containerFormat.map(value => value),
        diskImageFormat.map(value => value),
        s3Bucket.map(value => value),
        s3Prefix.map(value => value)
      )
    def containerFormat: Optional[zio.aws.ec2.model.ContainerFormat]
    def diskImageFormat: Optional[zio.aws.ec2.model.DiskImageFormat]
    def s3Bucket: Optional[String]
    def s3Prefix: Optional[String]
    def getContainerFormat
        : ZIO[Any, AwsError, zio.aws.ec2.model.ContainerFormat] =
      AwsError.unwrapOptionField("containerFormat", containerFormat)
    def getDiskImageFormat
        : ZIO[Any, AwsError, zio.aws.ec2.model.DiskImageFormat] =
      AwsError.unwrapOptionField("diskImageFormat", diskImageFormat)
    def getS3Bucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportToS3TaskSpecification
  ) extends zio.aws.ec2.model.ExportToS3TaskSpecification.ReadOnly {
    override val containerFormat: Optional[zio.aws.ec2.model.ContainerFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerFormat())
        .map(value => zio.aws.ec2.model.ContainerFormat.wrap(value))
    override val diskImageFormat: Optional[zio.aws.ec2.model.DiskImageFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskImageFormat())
        .map(value => zio.aws.ec2.model.DiskImageFormat.wrap(value))
    override val s3Bucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => value: String)
    override val s3Prefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Prefix())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportToS3TaskSpecification
  ): zio.aws.ec2.model.ExportToS3TaskSpecification.ReadOnly = new Wrapper(impl)
}
