package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFpgaImageAttributeResponse(
    fpgaImageAttribute: Optional[zio.aws.ec2.model.FpgaImageAttribute] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeResponse = {
    import DescribeFpgaImageAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeResponse
      .builder()
      .optionallyWith(fpgaImageAttribute.map(value => value.buildAwsValue()))(
        _.fpgaImageAttribute
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeFpgaImageAttributeResponse.ReadOnly =
    zio.aws.ec2.model.DescribeFpgaImageAttributeResponse.wrap(buildAwsValue())
}
object DescribeFpgaImageAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFpgaImageAttributeResponse =
      zio.aws.ec2.model.DescribeFpgaImageAttributeResponse(
        fpgaImageAttribute.map(value => value.asEditable)
      )
    def fpgaImageAttribute
        : Optional[zio.aws.ec2.model.FpgaImageAttribute.ReadOnly]
    def getFpgaImageAttribute
        : ZIO[Any, AwsError, zio.aws.ec2.model.FpgaImageAttribute.ReadOnly] =
      AwsError.unwrapOptionField("fpgaImageAttribute", fpgaImageAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeResponse
  ) extends zio.aws.ec2.model.DescribeFpgaImageAttributeResponse.ReadOnly {
    override val fpgaImageAttribute
        : Optional[zio.aws.ec2.model.FpgaImageAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fpgaImageAttribute())
        .map(value => zio.aws.ec2.model.FpgaImageAttribute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFpgaImageAttributeResponse
  ): zio.aws.ec2.model.DescribeFpgaImageAttributeResponse.ReadOnly =
    new Wrapper(impl)
}
