package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnConnectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVpnConnectionRouteRequest(
    destinationCidrBlock: String,
    vpnConnectionId: VpnConnectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteRequest = {
    import DeleteVpnConnectionRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteRequest
      .builder()
      .destinationCidrBlock(destinationCidrBlock: java.lang.String)
      .vpnConnectionId(
        VpnConnectionId.unwrap(vpnConnectionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteVpnConnectionRouteRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVpnConnectionRouteRequest.wrap(buildAwsValue())
}
object DeleteVpnConnectionRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVpnConnectionRouteRequest =
      zio.aws.ec2.model
        .DeleteVpnConnectionRouteRequest(destinationCidrBlock, vpnConnectionId)
    def destinationCidrBlock: String
    def vpnConnectionId: VpnConnectionId
    def getDestinationCidrBlock: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationCidrBlock)
    def getVpnConnectionId: ZIO[Any, Nothing, VpnConnectionId] =
      ZIO.succeed(vpnConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteRequest
  ) extends zio.aws.ec2.model.DeleteVpnConnectionRouteRequest.ReadOnly {
    override val destinationCidrBlock: String =
      impl.destinationCidrBlock(): String
    override val vpnConnectionId: VpnConnectionId =
      zio.aws.ec2.model.primitives.VpnConnectionId(impl.vpnConnectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpnConnectionRouteRequest
  ): zio.aws.ec2.model.DeleteVpnConnectionRouteRequest.ReadOnly = new Wrapper(
    impl
  )
}
