package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessEndpointId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVerifiedAccessEndpointRequest(
    verifiedAccessEndpointId: VerifiedAccessEndpointId,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessEndpointRequest = {
    import DeleteVerifiedAccessEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessEndpointRequest
      .builder()
      .verifiedAccessEndpointId(
        VerifiedAccessEndpointId.unwrap(
          verifiedAccessEndpointId
        ): java.lang.String
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteVerifiedAccessEndpointRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVerifiedAccessEndpointRequest.wrap(buildAwsValue())
}
object DeleteVerifiedAccessEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVerifiedAccessEndpointRequest =
      zio.aws.ec2.model.DeleteVerifiedAccessEndpointRequest(
        verifiedAccessEndpointId,
        clientToken.map(value => value)
      )
    def verifiedAccessEndpointId: VerifiedAccessEndpointId
    def clientToken: Optional[String]
    def getVerifiedAccessEndpointId
        : ZIO[Any, Nothing, VerifiedAccessEndpointId] =
      ZIO.succeed(verifiedAccessEndpointId)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessEndpointRequest
  ) extends zio.aws.ec2.model.DeleteVerifiedAccessEndpointRequest.ReadOnly {
    override val verifiedAccessEndpointId: VerifiedAccessEndpointId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessEndpointId(impl.verifiedAccessEndpointId())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessEndpointRequest
  ): zio.aws.ec2.model.DeleteVerifiedAccessEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
