package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayRouteTableId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayRouteRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    destinationCidrBlock: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteRequest = {
    import DeleteTransitGatewayRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .destinationCidrBlock(destinationCidrBlock: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteTransitGatewayRouteRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayRouteRequest.wrap(buildAwsValue())
}
object DeleteTransitGatewayRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTransitGatewayRouteRequest =
      zio.aws.ec2.model.DeleteTransitGatewayRouteRequest(
        transitGatewayRouteTableId,
        destinationCidrBlock
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def destinationCidrBlock: String
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getDestinationCidrBlock: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationCidrBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteRequest
  ) extends zio.aws.ec2.model.DeleteTransitGatewayRouteRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val destinationCidrBlock: String =
      impl.destinationCidrBlock(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteRequest
  ): zio.aws.ec2.model.DeleteTransitGatewayRouteRequest.ReadOnly = new Wrapper(
    impl
  )
}
