package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorSessionResponse(
    trafficMirrorSessionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse = {
    import DeleteTrafficMirrorSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse
      .builder()
      .optionallyWith(
        trafficMirrorSessionId.map(value => value: java.lang.String)
      )(_.trafficMirrorSessionId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.wrap(buildAwsValue())
}
object DeleteTrafficMirrorSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse =
      zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse(
        trafficMirrorSessionId.map(value => value)
      )
    def trafficMirrorSessionId: Optional[String]
    def getTrafficMirrorSessionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("trafficMirrorSessionId", trafficMirrorSessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.ReadOnly {
    override val trafficMirrorSessionId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorSessionId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorSessionResponse
  ): zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.ReadOnly =
    new Wrapper(impl)
}
