package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SubnetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateSubnetCidrReservationRequest(
    subnetId: SubnetId,
    cidr: String,
    reservationType: zio.aws.ec2.model.SubnetCidrReservationType,
    description: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationRequest = {
    import CreateSubnetCidrReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationRequest
      .builder()
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .cidr(cidr: java.lang.String)
      .reservationType(reservationType.unwrap)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateSubnetCidrReservationRequest.ReadOnly =
    zio.aws.ec2.model.CreateSubnetCidrReservationRequest.wrap(buildAwsValue())
}
object CreateSubnetCidrReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSubnetCidrReservationRequest =
      zio.aws.ec2.model.CreateSubnetCidrReservationRequest(
        subnetId,
        cidr,
        reservationType,
        description.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def subnetId: SubnetId
    def cidr: String
    def reservationType: zio.aws.ec2.model.SubnetCidrReservationType
    def description: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
    def getReservationType
        : ZIO[Any, Nothing, zio.aws.ec2.model.SubnetCidrReservationType] =
      ZIO.succeed(reservationType)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationRequest
  ) extends zio.aws.ec2.model.CreateSubnetCidrReservationRequest.ReadOnly {
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
    override val cidr: String = impl.cidr(): String
    override val reservationType: zio.aws.ec2.model.SubnetCidrReservationType =
      zio.aws.ec2.model.SubnetCidrReservationType.wrap(impl.reservationType())
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSubnetCidrReservationRequest
  ): zio.aws.ec2.model.CreateSubnetCidrReservationRequest.ReadOnly =
    new Wrapper(impl)
}
