package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStoreImageTaskRequest(
    imageId: ImageId,
    bucket: String,
    s3ObjectTags: Optional[Iterable[zio.aws.ec2.model.S3ObjectTag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskRequest = {
    import CreateStoreImageTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskRequest
      .builder()
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .bucket(bucket: java.lang.String)
      .optionallyWith(
        s3ObjectTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.s3ObjectTags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateStoreImageTaskRequest.ReadOnly =
    zio.aws.ec2.model.CreateStoreImageTaskRequest.wrap(buildAwsValue())
}
object CreateStoreImageTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateStoreImageTaskRequest =
      zio.aws.ec2.model.CreateStoreImageTaskRequest(
        imageId,
        bucket,
        s3ObjectTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def imageId: ImageId
    def bucket: String
    def s3ObjectTags: Optional[List[zio.aws.ec2.model.S3ObjectTag.ReadOnly]]
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
    def getBucket: ZIO[Any, Nothing, String] = ZIO.succeed(bucket)
    def getS3ObjectTags
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.S3ObjectTag.ReadOnly]] =
      AwsError.unwrapOptionField("s3ObjectTags", s3ObjectTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskRequest
  ) extends zio.aws.ec2.model.CreateStoreImageTaskRequest.ReadOnly {
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
    override val bucket: String = impl.bucket(): String
    override val s3ObjectTags
        : Optional[List[zio.aws.ec2.model.S3ObjectTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3ObjectTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.S3ObjectTag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskRequest
  ): zio.aws.ec2.model.CreateStoreImageTaskRequest.ReadOnly = new Wrapper(impl)
}
