package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SensitiveUserData
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKeyPairResponse(
    keyFingerprint: Optional[String] = Optional.Absent,
    keyMaterial: Optional[SensitiveUserData] = Optional.Absent,
    keyName: Optional[String] = Optional.Absent,
    keyPairId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateKeyPairResponse = {
    import CreateKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateKeyPairResponse
      .builder()
      .optionallyWith(keyFingerprint.map(value => value: java.lang.String))(
        _.keyFingerprint
      )
      .optionallyWith(
        keyMaterial.map(value =>
          SensitiveUserData.unwrap(value): java.lang.String
        )
      )(_.keyMaterial)
      .optionallyWith(keyName.map(value => value: java.lang.String))(_.keyName)
      .optionallyWith(keyPairId.map(value => value: java.lang.String))(
        _.keyPairId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateKeyPairResponse.ReadOnly =
    zio.aws.ec2.model.CreateKeyPairResponse.wrap(buildAwsValue())
}
object CreateKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateKeyPairResponse =
      zio.aws.ec2.model.CreateKeyPairResponse(
        keyFingerprint.map(value => value),
        keyMaterial.map(value => value),
        keyName.map(value => value),
        keyPairId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyFingerprint: Optional[String]
    def keyMaterial: Optional[SensitiveUserData]
    def keyName: Optional[String]
    def keyPairId: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getKeyFingerprint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyFingerprint", keyFingerprint)
    def getKeyMaterial: ZIO[Any, AwsError, SensitiveUserData] =
      AwsError.unwrapOptionField("keyMaterial", keyMaterial)
    def getKeyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getKeyPairId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyPairId", keyPairId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateKeyPairResponse
  ) extends zio.aws.ec2.model.CreateKeyPairResponse.ReadOnly {
    override val keyFingerprint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyFingerprint())
      .map(value => value: String)
    override val keyMaterial: Optional[SensitiveUserData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyMaterial())
        .map(value => zio.aws.ec2.model.primitives.SensitiveUserData(value))
    override val keyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => value: String)
    override val keyPairId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPairId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateKeyPairResponse
  ): zio.aws.ec2.model.CreateKeyPairResponse.ReadOnly = new Wrapper(impl)
}
