package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{IpamNetmaskLength, IpamPoolId, IpamScopeId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateIpamPoolRequest(
    ipamScopeId: IpamScopeId,
    locale: Optional[String] = Optional.Absent,
    sourceIpamPoolId: Optional[IpamPoolId] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    addressFamily: zio.aws.ec2.model.AddressFamily,
    autoImport: Optional[Boolean] = Optional.Absent,
    publiclyAdvertisable: Optional[Boolean] = Optional.Absent,
    allocationMinNetmaskLength: Optional[IpamNetmaskLength] = Optional.Absent,
    allocationMaxNetmaskLength: Optional[IpamNetmaskLength] = Optional.Absent,
    allocationDefaultNetmaskLength: Optional[IpamNetmaskLength] =
      Optional.Absent,
    allocationResourceTags: Optional[
      Iterable[zio.aws.ec2.model.RequestIpamResourceTag]
    ] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    awsService: Optional[zio.aws.ec2.model.IpamPoolAwsService] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest = {
    import CreateIpamPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest
      .builder()
      .ipamScopeId(IpamScopeId.unwrap(ipamScopeId): java.lang.String)
      .optionallyWith(locale.map(value => value: java.lang.String))(_.locale)
      .optionallyWith(
        sourceIpamPoolId.map(value =>
          IpamPoolId.unwrap(value): java.lang.String
        )
      )(_.sourceIpamPoolId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .addressFamily(addressFamily.unwrap)
      .optionallyWith(autoImport.map(value => value: java.lang.Boolean))(
        _.autoImport
      )
      .optionallyWith(
        publiclyAdvertisable.map(value => value: java.lang.Boolean)
      )(_.publiclyAdvertisable)
      .optionallyWith(
        allocationMinNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): Integer
        )
      )(_.allocationMinNetmaskLength)
      .optionallyWith(
        allocationMaxNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): Integer
        )
      )(_.allocationMaxNetmaskLength)
      .optionallyWith(
        allocationDefaultNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): Integer
        )
      )(_.allocationDefaultNetmaskLength)
      .optionallyWith(
        allocationResourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.allocationResourceTags)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(awsService.map(value => value.unwrap))(_.awsService)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateIpamPoolRequest.ReadOnly =
    zio.aws.ec2.model.CreateIpamPoolRequest.wrap(buildAwsValue())
}
object CreateIpamPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateIpamPoolRequest =
      zio.aws.ec2.model.CreateIpamPoolRequest(
        ipamScopeId,
        locale.map(value => value),
        sourceIpamPoolId.map(value => value),
        description.map(value => value),
        addressFamily,
        autoImport.map(value => value),
        publiclyAdvertisable.map(value => value),
        allocationMinNetmaskLength.map(value => value),
        allocationMaxNetmaskLength.map(value => value),
        allocationDefaultNetmaskLength.map(value => value),
        allocationResourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        awsService.map(value => value)
      )
    def ipamScopeId: IpamScopeId
    def locale: Optional[String]
    def sourceIpamPoolId: Optional[IpamPoolId]
    def description: Optional[String]
    def addressFamily: zio.aws.ec2.model.AddressFamily
    def autoImport: Optional[Boolean]
    def publiclyAdvertisable: Optional[Boolean]
    def allocationMinNetmaskLength: Optional[IpamNetmaskLength]
    def allocationMaxNetmaskLength: Optional[IpamNetmaskLength]
    def allocationDefaultNetmaskLength: Optional[IpamNetmaskLength]
    def allocationResourceTags
        : Optional[List[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: Optional[String]
    def awsService: Optional[zio.aws.ec2.model.IpamPoolAwsService]
    def getIpamScopeId: ZIO[Any, Nothing, IpamScopeId] =
      ZIO.succeed(ipamScopeId)
    def getLocale: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("locale", locale)
    def getSourceIpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("sourceIpamPoolId", sourceIpamPoolId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAddressFamily: ZIO[Any, Nothing, zio.aws.ec2.model.AddressFamily] =
      ZIO.succeed(addressFamily)
    def getAutoImport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoImport", autoImport)
    def getPubliclyAdvertisable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAdvertisable", publiclyAdvertisable)
    def getAllocationMinNetmaskLength: ZIO[Any, AwsError, IpamNetmaskLength] =
      AwsError.unwrapOptionField(
        "allocationMinNetmaskLength",
        allocationMinNetmaskLength
      )
    def getAllocationMaxNetmaskLength: ZIO[Any, AwsError, IpamNetmaskLength] =
      AwsError.unwrapOptionField(
        "allocationMaxNetmaskLength",
        allocationMaxNetmaskLength
      )
    def getAllocationDefaultNetmaskLength
        : ZIO[Any, AwsError, IpamNetmaskLength] = AwsError.unwrapOptionField(
      "allocationDefaultNetmaskLength",
      allocationDefaultNetmaskLength
    )
    def getAllocationResourceTags: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "allocationResourceTags",
      allocationResourceTags
    )
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getAwsService
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolAwsService] =
      AwsError.unwrapOptionField("awsService", awsService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest
  ) extends zio.aws.ec2.model.CreateIpamPoolRequest.ReadOnly {
    override val ipamScopeId: IpamScopeId =
      zio.aws.ec2.model.primitives.IpamScopeId(impl.ipamScopeId())
    override val locale: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value => value: String)
    override val sourceIpamPoolId: Optional[IpamPoolId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIpamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val addressFamily: zio.aws.ec2.model.AddressFamily =
      zio.aws.ec2.model.AddressFamily.wrap(impl.addressFamily())
    override val autoImport: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoImport())
      .map(value => value: Boolean)
    override val publiclyAdvertisable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAdvertisable())
      .map(value => value: Boolean)
    override val allocationMinNetmaskLength: Optional[IpamNetmaskLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationMinNetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationMaxNetmaskLength: Optional[IpamNetmaskLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationMaxNetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationDefaultNetmaskLength: Optional[IpamNetmaskLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationDefaultNetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationResourceTags
        : Optional[List[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationResourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RequestIpamResourceTag.wrap(item)
          }.toList
        )
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val awsService: Optional[zio.aws.ec2.model.IpamPoolAwsService] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsService())
        .map(value => zio.aws.ec2.model.IpamPoolAwsService.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest
  ): zio.aws.ec2.model.CreateIpamPoolRequest.ReadOnly = new Wrapper(impl)
}
