package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateImageResponse(
    imageId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateImageResponse = {
    import CreateImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateImageResponse
      .builder()
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateImageResponse.ReadOnly =
    zio.aws.ec2.model.CreateImageResponse.wrap(buildAwsValue())
}
object CreateImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateImageResponse =
      zio.aws.ec2.model.CreateImageResponse(imageId.map(value => value))
    def imageId: Optional[String]
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateImageResponse
  ) extends zio.aws.ec2.model.CreateImageResponse.ReadOnly {
    override val imageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateImageResponse
  ): zio.aws.ec2.model.CreateImageResponse.ReadOnly = new Wrapper(impl)
}
