package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFleetError(
    launchTemplateAndOverrides: Optional[
      zio.aws.ec2.model.LaunchTemplateAndOverridesResponse
    ] = Optional.Absent,
    lifecycle: Optional[zio.aws.ec2.model.InstanceLifecycle] = Optional.Absent,
    errorCode: Optional[String] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateFleetError = {
    import CreateFleetError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateFleetError
      .builder()
      .optionallyWith(
        launchTemplateAndOverrides.map(value => value.buildAwsValue())
      )(_.launchTemplateAndOverrides)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateFleetError.ReadOnly =
    zio.aws.ec2.model.CreateFleetError.wrap(buildAwsValue())
}
object CreateFleetError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateFleetError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateFleetError =
      zio.aws.ec2.model.CreateFleetError(
        launchTemplateAndOverrides.map(value => value.asEditable),
        lifecycle.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def launchTemplateAndOverrides: Optional[
      zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.ReadOnly
    ]
    def lifecycle: Optional[zio.aws.ec2.model.InstanceLifecycle]
    def errorCode: Optional[String]
    def errorMessage: Optional[String]
    def getLaunchTemplateAndOverrides: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "launchTemplateAndOverrides",
      launchTemplateAndOverrides
    )
    def getLifecycle: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateFleetError
  ) extends zio.aws.ec2.model.CreateFleetError.ReadOnly {
    override val launchTemplateAndOverrides: Optional[
      zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateAndOverrides())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.wrap(value)
      )
    override val lifecycle: Optional[zio.aws.ec2.model.InstanceLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.ec2.model.InstanceLifecycle.wrap(value))
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateFleetError
  ): zio.aws.ec2.model.CreateFleetError.ReadOnly = new Wrapper(impl)
}
