package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AllocationType {
  def unwrap: software.amazon.awssdk.services.ec2.model.AllocationType
}
object AllocationType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AllocationType
  ): zio.aws.ec2.model.AllocationType = value match {
    case software.amazon.awssdk.services.ec2.model.AllocationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AllocationType.USED =>
      val r = used
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.AllocationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationType =
      software.amazon.awssdk.services.ec2.model.AllocationType.UNKNOWN_TO_SDK_VERSION
  }
  case object used extends zio.aws.ec2.model.AllocationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationType =
      software.amazon.awssdk.services.ec2.model.AllocationType.USED
  }
}
