package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class AddressTransfer(
    publicIp: Optional[String] = Optional.Absent,
    allocationId: Optional[String] = Optional.Absent,
    transferAccountId: Optional[String] = Optional.Absent,
    transferOfferExpirationTimestamp: Optional[MillisecondDateTime] =
      Optional.Absent,
    transferOfferAcceptedTimestamp: Optional[MillisecondDateTime] =
      Optional.Absent,
    addressTransferStatus: Optional[zio.aws.ec2.model.AddressTransferStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AddressTransfer = {
    import AddressTransfer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AddressTransfer
      .builder()
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .optionallyWith(allocationId.map(value => value: java.lang.String))(
        _.allocationId
      )
      .optionallyWith(transferAccountId.map(value => value: java.lang.String))(
        _.transferAccountId
      )
      .optionallyWith(
        transferOfferExpirationTimestamp.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.transferOfferExpirationTimestamp)
      .optionallyWith(
        transferOfferAcceptedTimestamp.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.transferOfferAcceptedTimestamp)
      .optionallyWith(addressTransferStatus.map(value => value.unwrap))(
        _.addressTransferStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AddressTransfer.ReadOnly =
    zio.aws.ec2.model.AddressTransfer.wrap(buildAwsValue())
}
object AddressTransfer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AddressTransfer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AddressTransfer =
      zio.aws.ec2.model.AddressTransfer(
        publicIp.map(value => value),
        allocationId.map(value => value),
        transferAccountId.map(value => value),
        transferOfferExpirationTimestamp.map(value => value),
        transferOfferAcceptedTimestamp.map(value => value),
        addressTransferStatus.map(value => value)
      )
    def publicIp: Optional[String]
    def allocationId: Optional[String]
    def transferAccountId: Optional[String]
    def transferOfferExpirationTimestamp: Optional[MillisecondDateTime]
    def transferOfferAcceptedTimestamp: Optional[MillisecondDateTime]
    def addressTransferStatus: Optional[zio.aws.ec2.model.AddressTransferStatus]
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getAllocationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getTransferAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transferAccountId", transferAccountId)
    def getTransferOfferExpirationTimestamp
        : ZIO[Any, AwsError, MillisecondDateTime] = AwsError.unwrapOptionField(
      "transferOfferExpirationTimestamp",
      transferOfferExpirationTimestamp
    )
    def getTransferOfferAcceptedTimestamp
        : ZIO[Any, AwsError, MillisecondDateTime] = AwsError.unwrapOptionField(
      "transferOfferAcceptedTimestamp",
      transferOfferAcceptedTimestamp
    )
    def getAddressTransferStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.AddressTransferStatus] =
      AwsError.unwrapOptionField("addressTransferStatus", addressTransferStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AddressTransfer
  ) extends zio.aws.ec2.model.AddressTransfer.ReadOnly {
    override val publicIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => value: String)
    override val allocationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationId())
      .map(value => value: String)
    override val transferAccountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transferAccountId())
      .map(value => value: String)
    override val transferOfferExpirationTimestamp
        : Optional[MillisecondDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.transferOfferExpirationTimestamp())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val transferOfferAcceptedTimestamp: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transferOfferAcceptedTimestamp())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val addressTransferStatus
        : Optional[zio.aws.ec2.model.AddressTransferStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addressTransferStatus())
        .map(value => zio.aws.ec2.model.AddressTransferStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AddressTransfer
  ): zio.aws.ec2.model.AddressTransfer.ReadOnly = new Wrapper(impl)
}
