package zio.aws.ec2
import zio.aws.ec2.model.primitives.AddressMaxResults.Type
import java.time.Instant
import zio.Chunk
import zio.aws.ec2.model.primitives.{
  SubnetId,
  VpcId,
  FlowLogResourceId,
  Ipv4PoolEc2Id,
  TaggableResourceId,
  TrafficMirrorTargetId,
  TransitGatewayPolicyTableId,
  ReplaceRootVolumeTaskId,
  IamInstanceProfileAssociationId,
  FleetId,
  NetworkInsightsAccessScopeAnalysisId,
  ReservedInstancesModificationId,
  LocalGatewayVirtualInterfaceId,
  TrafficMirrorSessionId,
  KeyPairName,
  ExportTaskId,
  SecurityGroupId,
  ScheduledInstanceId,
  LocalGatewayRouteTableVpcAssociationId,
  TransitGatewayRouteTableId,
  LaunchTemplateId,
  ConversionTaskId,
  NetworkInterfaceId,
  VpnGatewayId,
  InternetGatewayId,
  ReservationId,
  LocalGatewayVirtualInterfaceGroupId,
  ReservedInstancesOfferingId,
  Ipv6PoolEc2Id,
  InstanceId,
  CapacityReservationId,
  LocalGatewayRouteTableVirtualInterfaceGroupAssociationId,
  TransitGatewayConnectPeerId,
  NetworkAclId,
  RouteTableId,
  ExportImageTaskId,
  TransitGatewayAttachmentId,
  VpcFlowLogId,
  LaunchTemplateName,
  CarrierGatewayId,
  Integer,
  VpcEndpointServiceId,
  EgressOnlyInternetGatewayId,
  ImportSnapshotTaskId,
  IpAddress,
  VpnConnectionId,
  KeyPairId,
  TransitGatewayId,
  PlacementGroupName,
  CapacityReservationFleetId,
  VolumeId,
  SnapshotId,
  TransitGatewayMulticastDomainId,
  ConnectionNotificationId,
  CustomerGatewayId,
  ExcludedInstanceType,
  NetworkInsightsPathId,
  AllocationId,
  Ipv4PoolCoipId,
  SecurityGroupName,
  NatGatewayId,
  LocalGatewayRoutetableId,
  ResourceArn,
  VpcPeeringConnectionId,
  CoreCount,
  DedicatedHostId,
  DhcpOptionsId,
  FpgaImageId,
  ImportImageTaskId,
  VpcEndpointId,
  NetworkInterfacePermissionId,
  ElasticGpuId,
  HostReservationId,
  NetworkInsightsAnalysisId,
  SpotInstanceRequestId,
  ClientVpnEndpointId,
  BundleId,
  TrafficMirrorFilterId,
  TransitGatewayRouteTableAnnouncementId,
  TrunkInterfaceAssociationId,
  ImageId,
  PlacementGroupId,
  ThreadsPerCore,
  SpotFleetRequestId,
  InstanceEventWindowId,
  LocalGatewayId,
  PrefixListResourceId,
  NetworkInsightsAccessScopeId
}
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AddressMaxResults extends Subtype[Int]
    type AddressMaxResults = zio.aws.ec2.model.primitives.AddressMaxResults.Type
    object AllocationId extends Subtype[String]
    type AllocationId = zio.aws.ec2.model.primitives.AllocationId.Type
    object AutoRecoveryFlag extends Subtype[Boolean]
    type AutoRecoveryFlag = zio.aws.ec2.model.primitives.AutoRecoveryFlag.Type
    object BareMetalFlag extends Subtype[Boolean]
    type BareMetalFlag = zio.aws.ec2.model.primitives.BareMetalFlag.Type
    object BaselineBandwidthInMbps extends Subtype[Int]
    type BaselineBandwidthInMbps =
      zio.aws.ec2.model.primitives.BaselineBandwidthInMbps.Type
    object BaselineIops extends Subtype[Int]
    type BaselineIops = zio.aws.ec2.model.primitives.BaselineIops.Type
    object BaselineThroughputInMBps extends Subtype[Double]
    type BaselineThroughputInMBps =
      zio.aws.ec2.model.primitives.BaselineThroughputInMBps.Type
    object Blob extends Subtype[Chunk[Byte]]
    type Blob = zio.aws.ec2.model.primitives.Blob.Type
    type BoxedDouble = Double
    object BundleId extends Subtype[String]
    type BundleId = zio.aws.ec2.model.primitives.BundleId.Type
    object BurstablePerformanceFlag extends Subtype[Boolean]
    type BurstablePerformanceFlag =
      zio.aws.ec2.model.primitives.BurstablePerformanceFlag.Type
    object CancelCapacityReservationFleetErrorCode extends Subtype[String]
    type CancelCapacityReservationFleetErrorCode =
      zio.aws.ec2.model.primitives.CancelCapacityReservationFleetErrorCode.Type
    object CancelCapacityReservationFleetErrorMessage extends Subtype[String]
    type CancelCapacityReservationFleetErrorMessage =
      zio.aws.ec2.model.primitives.CancelCapacityReservationFleetErrorMessage.Type
    object CapacityReservationFleetId extends Subtype[String]
    type CapacityReservationFleetId =
      zio.aws.ec2.model.primitives.CapacityReservationFleetId.Type
    object CapacityReservationId extends Subtype[String]
    type CapacityReservationId =
      zio.aws.ec2.model.primitives.CapacityReservationId.Type
    object CarrierGatewayId extends Subtype[String]
    type CarrierGatewayId = zio.aws.ec2.model.primitives.CarrierGatewayId.Type
    object CarrierGatewayMaxResults extends Subtype[Int]
    type CarrierGatewayMaxResults =
      zio.aws.ec2.model.primitives.CarrierGatewayMaxResults.Type
    object ClientVpnAssociationId extends Subtype[String]
    type ClientVpnAssociationId =
      zio.aws.ec2.model.primitives.ClientVpnAssociationId.Type
    object ClientVpnEndpointId extends Subtype[String]
    type ClientVpnEndpointId =
      zio.aws.ec2.model.primitives.ClientVpnEndpointId.Type
    object CloudWatchLogGroupArn extends Subtype[String]
    type CloudWatchLogGroupArn =
      zio.aws.ec2.model.primitives.CloudWatchLogGroupArn.Type
    object CoipPoolId extends Subtype[String]
    type CoipPoolId = zio.aws.ec2.model.primitives.CoipPoolId.Type
    object CoipPoolMaxResults extends Subtype[Int]
    type CoipPoolMaxResults =
      zio.aws.ec2.model.primitives.CoipPoolMaxResults.Type
    object ComponentAccount extends Subtype[String]
    type ComponentAccount = zio.aws.ec2.model.primitives.ComponentAccount.Type
    object ComponentRegion extends Subtype[String]
    type ComponentRegion = zio.aws.ec2.model.primitives.ComponentRegion.Type
    object ConnectionNotificationId extends Subtype[String]
    type ConnectionNotificationId =
      zio.aws.ec2.model.primitives.ConnectionNotificationId.Type
    object ConversionTaskId extends Subtype[String]
    type ConversionTaskId = zio.aws.ec2.model.primitives.ConversionTaskId.Type
    object CoreCount extends Subtype[Int]
    type CoreCount = zio.aws.ec2.model.primitives.CoreCount.Type
    object CoreNetworkArn extends Subtype[String]
    type CoreNetworkArn = zio.aws.ec2.model.primitives.CoreNetworkArn.Type
    object CurrentGenerationFlag extends Subtype[Boolean]
    type CurrentGenerationFlag =
      zio.aws.ec2.model.primitives.CurrentGenerationFlag.Type
    object CustomerGatewayId extends Subtype[String]
    type CustomerGatewayId = zio.aws.ec2.model.primitives.CustomerGatewayId.Type
    object DITMaxResults extends Subtype[Int]
    type DITMaxResults = zio.aws.ec2.model.primitives.DITMaxResults.Type
    object DITOMaxResults extends Subtype[Int]
    type DITOMaxResults = zio.aws.ec2.model.primitives.DITOMaxResults.Type
    object DateTime extends Subtype[Instant]
    type DateTime = zio.aws.ec2.model.primitives.DateTime.Type
    object DedicatedHostFlag extends Subtype[Boolean]
    type DedicatedHostFlag = zio.aws.ec2.model.primitives.DedicatedHostFlag.Type
    object DedicatedHostId extends Subtype[String]
    type DedicatedHostId = zio.aws.ec2.model.primitives.DedicatedHostId.Type
    object DefaultNetworkCardIndex extends Subtype[Int]
    type DefaultNetworkCardIndex =
      zio.aws.ec2.model.primitives.DefaultNetworkCardIndex.Type
    object DefaultingDhcpOptionsId extends Subtype[String]
    type DefaultingDhcpOptionsId =
      zio.aws.ec2.model.primitives.DefaultingDhcpOptionsId.Type
    object DescribeByoipCidrsMaxResults extends Subtype[Int]
    type DescribeByoipCidrsMaxResults =
      zio.aws.ec2.model.primitives.DescribeByoipCidrsMaxResults.Type
    object DescribeCapacityReservationFleetsMaxResults extends Subtype[Int]
    type DescribeCapacityReservationFleetsMaxResults =
      zio.aws.ec2.model.primitives.DescribeCapacityReservationFleetsMaxResults.Type
    object DescribeCapacityReservationsMaxResults extends Subtype[Int]
    type DescribeCapacityReservationsMaxResults =
      zio.aws.ec2.model.primitives.DescribeCapacityReservationsMaxResults.Type
    object DescribeClassicLinkInstancesMaxResults extends Subtype[Int]
    type DescribeClassicLinkInstancesMaxResults =
      zio.aws.ec2.model.primitives.DescribeClassicLinkInstancesMaxResults.Type
    object DescribeClientVpnAuthorizationRulesMaxResults extends Subtype[Int]
    type DescribeClientVpnAuthorizationRulesMaxResults =
      zio.aws.ec2.model.primitives.DescribeClientVpnAuthorizationRulesMaxResults.Type
    object DescribeClientVpnConnectionsMaxResults extends Subtype[Int]
    type DescribeClientVpnConnectionsMaxResults =
      zio.aws.ec2.model.primitives.DescribeClientVpnConnectionsMaxResults.Type
    object DescribeClientVpnEndpointMaxResults extends Subtype[Int]
    type DescribeClientVpnEndpointMaxResults =
      zio.aws.ec2.model.primitives.DescribeClientVpnEndpointMaxResults.Type
    object DescribeClientVpnRoutesMaxResults extends Subtype[Int]
    type DescribeClientVpnRoutesMaxResults =
      zio.aws.ec2.model.primitives.DescribeClientVpnRoutesMaxResults.Type
    object DescribeClientVpnTargetNetworksMaxResults extends Subtype[Int]
    type DescribeClientVpnTargetNetworksMaxResults =
      zio.aws.ec2.model.primitives.DescribeClientVpnTargetNetworksMaxResults.Type
    object DescribeDhcpOptionsMaxResults extends Subtype[Int]
    type DescribeDhcpOptionsMaxResults =
      zio.aws.ec2.model.primitives.DescribeDhcpOptionsMaxResults.Type
    object DescribeEgressOnlyInternetGatewaysMaxResults extends Subtype[Int]
    type DescribeEgressOnlyInternetGatewaysMaxResults =
      zio.aws.ec2.model.primitives.DescribeEgressOnlyInternetGatewaysMaxResults.Type
    object DescribeElasticGpusMaxResults extends Subtype[Int]
    type DescribeElasticGpusMaxResults =
      zio.aws.ec2.model.primitives.DescribeElasticGpusMaxResults.Type
    object DescribeExportImageTasksMaxResults extends Subtype[Int]
    type DescribeExportImageTasksMaxResults =
      zio.aws.ec2.model.primitives.DescribeExportImageTasksMaxResults.Type
    object DescribeFastLaunchImagesRequestMaxResults extends Subtype[Int]
    type DescribeFastLaunchImagesRequestMaxResults =
      zio.aws.ec2.model.primitives.DescribeFastLaunchImagesRequestMaxResults.Type
    object DescribeFastSnapshotRestoresMaxResults extends Subtype[Int]
    type DescribeFastSnapshotRestoresMaxResults =
      zio.aws.ec2.model.primitives.DescribeFastSnapshotRestoresMaxResults.Type
    object DescribeFpgaImagesMaxResults extends Subtype[Int]
    type DescribeFpgaImagesMaxResults =
      zio.aws.ec2.model.primitives.DescribeFpgaImagesMaxResults.Type
    object DescribeHostReservationsMaxResults extends Subtype[Int]
    type DescribeHostReservationsMaxResults =
      zio.aws.ec2.model.primitives.DescribeHostReservationsMaxResults.Type
    object DescribeIamInstanceProfileAssociationsMaxResults extends Subtype[Int]
    type DescribeIamInstanceProfileAssociationsMaxResults =
      zio.aws.ec2.model.primitives.DescribeIamInstanceProfileAssociationsMaxResults.Type
    object DescribeInstanceCreditSpecificationsMaxResults extends Subtype[Int]
    type DescribeInstanceCreditSpecificationsMaxResults =
      zio.aws.ec2.model.primitives.DescribeInstanceCreditSpecificationsMaxResults.Type
    object DescribeInternetGatewaysMaxResults extends Subtype[Int]
    type DescribeInternetGatewaysMaxResults =
      zio.aws.ec2.model.primitives.DescribeInternetGatewaysMaxResults.Type
    object DescribeLaunchTemplatesMaxResults extends Subtype[Int]
    type DescribeLaunchTemplatesMaxResults =
      zio.aws.ec2.model.primitives.DescribeLaunchTemplatesMaxResults.Type
    object DescribeMovingAddressesMaxResults extends Subtype[Int]
    type DescribeMovingAddressesMaxResults =
      zio.aws.ec2.model.primitives.DescribeMovingAddressesMaxResults.Type
    object DescribeNatGatewaysMaxResults extends Subtype[Int]
    type DescribeNatGatewaysMaxResults =
      zio.aws.ec2.model.primitives.DescribeNatGatewaysMaxResults.Type
    object DescribeNetworkAclsMaxResults extends Subtype[Int]
    type DescribeNetworkAclsMaxResults =
      zio.aws.ec2.model.primitives.DescribeNetworkAclsMaxResults.Type
    object DescribeNetworkInterfacePermissionsMaxResults extends Subtype[Int]
    type DescribeNetworkInterfacePermissionsMaxResults =
      zio.aws.ec2.model.primitives.DescribeNetworkInterfacePermissionsMaxResults.Type
    object DescribeNetworkInterfacesMaxResults extends Subtype[Int]
    type DescribeNetworkInterfacesMaxResults =
      zio.aws.ec2.model.primitives.DescribeNetworkInterfacesMaxResults.Type
    object DescribePrincipalIdFormatMaxResults extends Subtype[Int]
    type DescribePrincipalIdFormatMaxResults =
      zio.aws.ec2.model.primitives.DescribePrincipalIdFormatMaxResults.Type
    object DescribeReplaceRootVolumeTasksMaxResults extends Subtype[Int]
    type DescribeReplaceRootVolumeTasksMaxResults =
      zio.aws.ec2.model.primitives.DescribeReplaceRootVolumeTasksMaxResults.Type
    object DescribeRouteTablesMaxResults extends Subtype[Int]
    type DescribeRouteTablesMaxResults =
      zio.aws.ec2.model.primitives.DescribeRouteTablesMaxResults.Type
    object DescribeScheduledInstanceAvailabilityMaxResults extends Subtype[Int]
    type DescribeScheduledInstanceAvailabilityMaxResults =
      zio.aws.ec2.model.primitives.DescribeScheduledInstanceAvailabilityMaxResults.Type
    object DescribeSecurityGroupRulesMaxResults extends Subtype[Int]
    type DescribeSecurityGroupRulesMaxResults =
      zio.aws.ec2.model.primitives.DescribeSecurityGroupRulesMaxResults.Type
    object DescribeSecurityGroupsMaxResults extends Subtype[Int]
    type DescribeSecurityGroupsMaxResults =
      zio.aws.ec2.model.primitives.DescribeSecurityGroupsMaxResults.Type
    object DescribeSnapshotTierStatusMaxResults extends Subtype[Int]
    type DescribeSnapshotTierStatusMaxResults =
      zio.aws.ec2.model.primitives.DescribeSnapshotTierStatusMaxResults.Type
    object DescribeSpotFleetInstancesMaxResults extends Subtype[Int]
    type DescribeSpotFleetInstancesMaxResults =
      zio.aws.ec2.model.primitives.DescribeSpotFleetInstancesMaxResults.Type
    object DescribeSpotFleetRequestHistoryMaxResults extends Subtype[Int]
    type DescribeSpotFleetRequestHistoryMaxResults =
      zio.aws.ec2.model.primitives.DescribeSpotFleetRequestHistoryMaxResults.Type
    object DescribeStaleSecurityGroupsMaxResults extends Subtype[Int]
    type DescribeStaleSecurityGroupsMaxResults =
      zio.aws.ec2.model.primitives.DescribeStaleSecurityGroupsMaxResults.Type
    object DescribeStaleSecurityGroupsNextToken extends Subtype[String]
    type DescribeStaleSecurityGroupsNextToken =
      zio.aws.ec2.model.primitives.DescribeStaleSecurityGroupsNextToken.Type
    object DescribeStoreImageTasksRequestMaxResults extends Subtype[Int]
    type DescribeStoreImageTasksRequestMaxResults =
      zio.aws.ec2.model.primitives.DescribeStoreImageTasksRequestMaxResults.Type
    object DescribeSubnetsMaxResults extends Subtype[Int]
    type DescribeSubnetsMaxResults =
      zio.aws.ec2.model.primitives.DescribeSubnetsMaxResults.Type
    object DescribeTrunkInterfaceAssociationsMaxResults extends Subtype[Int]
    type DescribeTrunkInterfaceAssociationsMaxResults =
      zio.aws.ec2.model.primitives.DescribeTrunkInterfaceAssociationsMaxResults.Type
    object DescribeVpcClassicLinkDnsSupportMaxResults extends Subtype[Int]
    type DescribeVpcClassicLinkDnsSupportMaxResults =
      zio.aws.ec2.model.primitives.DescribeVpcClassicLinkDnsSupportMaxResults.Type
    object DescribeVpcClassicLinkDnsSupportNextToken extends Subtype[String]
    type DescribeVpcClassicLinkDnsSupportNextToken =
      zio.aws.ec2.model.primitives.DescribeVpcClassicLinkDnsSupportNextToken.Type
    object DescribeVpcPeeringConnectionsMaxResults extends Subtype[Int]
    type DescribeVpcPeeringConnectionsMaxResults =
      zio.aws.ec2.model.primitives.DescribeVpcPeeringConnectionsMaxResults.Type
    object DescribeVpcsMaxResults extends Subtype[Int]
    type DescribeVpcsMaxResults =
      zio.aws.ec2.model.primitives.DescribeVpcsMaxResults.Type
    object DhcpOptionsId extends Subtype[String]
    type DhcpOptionsId = zio.aws.ec2.model.primitives.DhcpOptionsId.Type
    object DiskCount extends Subtype[Int]
    type DiskCount = zio.aws.ec2.model.primitives.DiskCount.Type
    object DiskSize extends Subtype[Long]
    type DiskSize = zio.aws.ec2.model.primitives.DiskSize.Type
    object DoubleWithConstraints extends Subtype[Double]
    type DoubleWithConstraints =
      zio.aws.ec2.model.primitives.DoubleWithConstraints.Type
    object EfaSupportedFlag extends Subtype[Boolean]
    type EfaSupportedFlag = zio.aws.ec2.model.primitives.EfaSupportedFlag.Type
    object EgressOnlyInternetGatewayId extends Subtype[String]
    type EgressOnlyInternetGatewayId =
      zio.aws.ec2.model.primitives.EgressOnlyInternetGatewayId.Type
    object ElasticGpuId extends Subtype[String]
    type ElasticGpuId = zio.aws.ec2.model.primitives.ElasticGpuId.Type
    object ElasticInferenceAcceleratorCount extends Subtype[Int]
    type ElasticInferenceAcceleratorCount =
      zio.aws.ec2.model.primitives.ElasticInferenceAcceleratorCount.Type
    object ElasticIpAssociationId extends Subtype[String]
    type ElasticIpAssociationId =
      zio.aws.ec2.model.primitives.ElasticIpAssociationId.Type
    object EncryptionInTransitSupported extends Subtype[Boolean]
    type EncryptionInTransitSupported =
      zio.aws.ec2.model.primitives.EncryptionInTransitSupported.Type
    object ExcludedInstanceType extends Subtype[String]
    type ExcludedInstanceType =
      zio.aws.ec2.model.primitives.ExcludedInstanceType.Type
    object ExportImageTaskId extends Subtype[String]
    type ExportImageTaskId = zio.aws.ec2.model.primitives.ExportImageTaskId.Type
    object ExportTaskId extends Subtype[String]
    type ExportTaskId = zio.aws.ec2.model.primitives.ExportTaskId.Type
    object ExportVmTaskId extends Subtype[String]
    type ExportVmTaskId = zio.aws.ec2.model.primitives.ExportVmTaskId.Type
    object FleetId extends Subtype[String]
    type FleetId = zio.aws.ec2.model.primitives.FleetId.Type
    object FlowLogResourceId extends Subtype[String]
    type FlowLogResourceId = zio.aws.ec2.model.primitives.FlowLogResourceId.Type
    object FpgaDeviceCount extends Subtype[Int]
    type FpgaDeviceCount = zio.aws.ec2.model.primitives.FpgaDeviceCount.Type
    object FpgaDeviceManufacturerName extends Subtype[String]
    type FpgaDeviceManufacturerName =
      zio.aws.ec2.model.primitives.FpgaDeviceManufacturerName.Type
    object FpgaDeviceMemorySize extends Subtype[Int]
    type FpgaDeviceMemorySize =
      zio.aws.ec2.model.primitives.FpgaDeviceMemorySize.Type
    object FpgaDeviceName extends Subtype[String]
    type FpgaDeviceName = zio.aws.ec2.model.primitives.FpgaDeviceName.Type
    object FpgaImageId extends Subtype[String]
    type FpgaImageId = zio.aws.ec2.model.primitives.FpgaImageId.Type
    object FreeTierEligibleFlag extends Subtype[Boolean]
    type FreeTierEligibleFlag =
      zio.aws.ec2.model.primitives.FreeTierEligibleFlag.Type
    object GVCDMaxResults extends Subtype[Int]
    type GVCDMaxResults = zio.aws.ec2.model.primitives.GVCDMaxResults.Type
    object GetCapacityReservationUsageRequestMaxResults extends Subtype[Int]
    type GetCapacityReservationUsageRequestMaxResults =
      zio.aws.ec2.model.primitives.GetCapacityReservationUsageRequestMaxResults.Type
    object GetGroupsForCapacityReservationRequestMaxResults extends Subtype[Int]
    type GetGroupsForCapacityReservationRequestMaxResults =
      zio.aws.ec2.model.primitives.GetGroupsForCapacityReservationRequestMaxResults.Type
    object GetIpamPoolAllocationsMaxResults extends Subtype[Int]
    type GetIpamPoolAllocationsMaxResults =
      zio.aws.ec2.model.primitives.GetIpamPoolAllocationsMaxResults.Type
    object GetManagedPrefixListAssociationsMaxResults extends Subtype[Int]
    type GetManagedPrefixListAssociationsMaxResults =
      zio.aws.ec2.model.primitives.GetManagedPrefixListAssociationsMaxResults.Type
    object GetSubnetCidrReservationsMaxResults extends Subtype[Int]
    type GetSubnetCidrReservationsMaxResults =
      zio.aws.ec2.model.primitives.GetSubnetCidrReservationsMaxResults.Type
    object GpuDeviceCount extends Subtype[Int]
    type GpuDeviceCount = zio.aws.ec2.model.primitives.GpuDeviceCount.Type
    object GpuDeviceManufacturerName extends Subtype[String]
    type GpuDeviceManufacturerName =
      zio.aws.ec2.model.primitives.GpuDeviceManufacturerName.Type
    object GpuDeviceMemorySize extends Subtype[Int]
    type GpuDeviceMemorySize =
      zio.aws.ec2.model.primitives.GpuDeviceMemorySize.Type
    object GpuDeviceName extends Subtype[String]
    type GpuDeviceName = zio.aws.ec2.model.primitives.GpuDeviceName.Type
    object HibernationFlag extends Subtype[Boolean]
    type HibernationFlag = zio.aws.ec2.model.primitives.HibernationFlag.Type
    object HostReservationId extends Subtype[String]
    type HostReservationId = zio.aws.ec2.model.primitives.HostReservationId.Type
    object Hour extends Subtype[Int]
    type Hour = zio.aws.ec2.model.primitives.Hour.Type
    object IamInstanceProfileAssociationId extends Subtype[String]
    type IamInstanceProfileAssociationId =
      zio.aws.ec2.model.primitives.IamInstanceProfileAssociationId.Type
    object ImageId extends Subtype[String]
    type ImageId = zio.aws.ec2.model.primitives.ImageId.Type
    object ImportImageTaskId extends Subtype[String]
    type ImportImageTaskId = zio.aws.ec2.model.primitives.ImportImageTaskId.Type
    object ImportSnapshotTaskId extends Subtype[String]
    type ImportSnapshotTaskId =
      zio.aws.ec2.model.primitives.ImportSnapshotTaskId.Type
    object ImportTaskId extends Subtype[String]
    type ImportTaskId = zio.aws.ec2.model.primitives.ImportTaskId.Type
    object InferenceDeviceCount extends Subtype[Int]
    type InferenceDeviceCount =
      zio.aws.ec2.model.primitives.InferenceDeviceCount.Type
    object InferenceDeviceManufacturerName extends Subtype[String]
    type InferenceDeviceManufacturerName =
      zio.aws.ec2.model.primitives.InferenceDeviceManufacturerName.Type
    object InferenceDeviceName extends Subtype[String]
    type InferenceDeviceName =
      zio.aws.ec2.model.primitives.InferenceDeviceName.Type
    object InstanceEventId extends Subtype[String]
    type InstanceEventId = zio.aws.ec2.model.primitives.InstanceEventId.Type
    object InstanceEventWindowCronExpression extends Subtype[String]
    type InstanceEventWindowCronExpression =
      zio.aws.ec2.model.primitives.InstanceEventWindowCronExpression.Type
    object InstanceEventWindowId extends Subtype[String]
    type InstanceEventWindowId =
      zio.aws.ec2.model.primitives.InstanceEventWindowId.Type
    object InstanceId extends Subtype[String]
    type InstanceId = zio.aws.ec2.model.primitives.InstanceId.Type
    object InstanceStorageFlag extends Subtype[Boolean]
    type InstanceStorageFlag =
      zio.aws.ec2.model.primitives.InstanceStorageFlag.Type
    type Integer = Int
    object IntegerWithConstraints extends Subtype[Int]
    type IntegerWithConstraints =
      zio.aws.ec2.model.primitives.IntegerWithConstraints.Type
    object InternetGatewayId extends Subtype[String]
    type InternetGatewayId = zio.aws.ec2.model.primitives.InternetGatewayId.Type
    object IpAddress extends Subtype[String]
    type IpAddress = zio.aws.ec2.model.primitives.IpAddress.Type
    object IpamAddressHistoryMaxResults extends Subtype[Int]
    type IpamAddressHistoryMaxResults =
      zio.aws.ec2.model.primitives.IpamAddressHistoryMaxResults.Type
    object IpamId extends Subtype[String]
    type IpamId = zio.aws.ec2.model.primitives.IpamId.Type
    object IpamMaxResults extends Subtype[Int]
    type IpamMaxResults = zio.aws.ec2.model.primitives.IpamMaxResults.Type
    object IpamNetmaskLength extends Subtype[Int]
    type IpamNetmaskLength = zio.aws.ec2.model.primitives.IpamNetmaskLength.Type
    object IpamPoolAllocationId extends Subtype[String]
    type IpamPoolAllocationId =
      zio.aws.ec2.model.primitives.IpamPoolAllocationId.Type
    object IpamPoolId extends Subtype[String]
    type IpamPoolId = zio.aws.ec2.model.primitives.IpamPoolId.Type
    object IpamScopeId extends Subtype[String]
    type IpamScopeId = zio.aws.ec2.model.primitives.IpamScopeId.Type
    object Ipv4PoolCoipId extends Subtype[String]
    type Ipv4PoolCoipId = zio.aws.ec2.model.primitives.Ipv4PoolCoipId.Type
    object Ipv4PoolEc2Id extends Subtype[String]
    type Ipv4PoolEc2Id = zio.aws.ec2.model.primitives.Ipv4PoolEc2Id.Type
    object Ipv6Address extends Subtype[String]
    type Ipv6Address = zio.aws.ec2.model.primitives.Ipv6Address.Type
    object Ipv6Flag extends Subtype[Boolean]
    type Ipv6Flag = zio.aws.ec2.model.primitives.Ipv6Flag.Type
    object Ipv6PoolEc2Id extends Subtype[String]
    type Ipv6PoolEc2Id = zio.aws.ec2.model.primitives.Ipv6PoolEc2Id.Type
    object Ipv6PoolMaxResults extends Subtype[Int]
    type Ipv6PoolMaxResults =
      zio.aws.ec2.model.primitives.Ipv6PoolMaxResults.Type
    object KernelId extends Subtype[String]
    type KernelId = zio.aws.ec2.model.primitives.KernelId.Type
    object KeyPairId extends Subtype[String]
    type KeyPairId = zio.aws.ec2.model.primitives.KeyPairId.Type
    object KeyPairName extends Subtype[String]
    type KeyPairName = zio.aws.ec2.model.primitives.KeyPairName.Type
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.ec2.model.primitives.KmsKeyId.Type
    object LaunchTemplateElasticInferenceAcceleratorCount extends Subtype[Int]
    type LaunchTemplateElasticInferenceAcceleratorCount =
      zio.aws.ec2.model.primitives.LaunchTemplateElasticInferenceAcceleratorCount.Type
    object LaunchTemplateId extends Subtype[String]
    type LaunchTemplateId = zio.aws.ec2.model.primitives.LaunchTemplateId.Type
    object LaunchTemplateName extends Subtype[String]
    type LaunchTemplateName =
      zio.aws.ec2.model.primitives.LaunchTemplateName.Type
    object ListImagesInRecycleBinMaxResults extends Subtype[Int]
    type ListImagesInRecycleBinMaxResults =
      zio.aws.ec2.model.primitives.ListImagesInRecycleBinMaxResults.Type
    object ListSnapshotsInRecycleBinMaxResults extends Subtype[Int]
    type ListSnapshotsInRecycleBinMaxResults =
      zio.aws.ec2.model.primitives.ListSnapshotsInRecycleBinMaxResults.Type
    object LocalGatewayId extends Subtype[String]
    type LocalGatewayId = zio.aws.ec2.model.primitives.LocalGatewayId.Type
    object LocalGatewayMaxResults extends Subtype[Int]
    type LocalGatewayMaxResults =
      zio.aws.ec2.model.primitives.LocalGatewayMaxResults.Type
    object LocalGatewayRouteTableVirtualInterfaceGroupAssociationId
        extends Subtype[String]
    type LocalGatewayRouteTableVirtualInterfaceGroupAssociationId =
      zio.aws.ec2.model.primitives.LocalGatewayRouteTableVirtualInterfaceGroupAssociationId.Type
    object LocalGatewayRouteTableVpcAssociationId extends Subtype[String]
    type LocalGatewayRouteTableVpcAssociationId =
      zio.aws.ec2.model.primitives.LocalGatewayRouteTableVpcAssociationId.Type
    object LocalGatewayRoutetableId extends Subtype[String]
    type LocalGatewayRoutetableId =
      zio.aws.ec2.model.primitives.LocalGatewayRoutetableId.Type
    object LocalGatewayVirtualInterfaceGroupId extends Subtype[String]
    type LocalGatewayVirtualInterfaceGroupId =
      zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceGroupId.Type
    object LocalGatewayVirtualInterfaceId extends Subtype[String]
    type LocalGatewayVirtualInterfaceId =
      zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceId.Type
    object Location extends Subtype[String]
    type Location = zio.aws.ec2.model.primitives.Location.Type
    object MaxIpv4AddrPerInterface extends Subtype[Int]
    type MaxIpv4AddrPerInterface =
      zio.aws.ec2.model.primitives.MaxIpv4AddrPerInterface.Type
    object MaxIpv6AddrPerInterface extends Subtype[Int]
    type MaxIpv6AddrPerInterface =
      zio.aws.ec2.model.primitives.MaxIpv6AddrPerInterface.Type
    object MaxNetworkInterfaces extends Subtype[Int]
    type MaxNetworkInterfaces =
      zio.aws.ec2.model.primitives.MaxNetworkInterfaces.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.ec2.model.primitives.MaxResults.Type
    object MaximumBandwidthInMbps extends Subtype[Int]
    type MaximumBandwidthInMbps =
      zio.aws.ec2.model.primitives.MaximumBandwidthInMbps.Type
    object MaximumEfaInterfaces extends Subtype[Int]
    type MaximumEfaInterfaces =
      zio.aws.ec2.model.primitives.MaximumEfaInterfaces.Type
    object MaximumIops extends Subtype[Int]
    type MaximumIops = zio.aws.ec2.model.primitives.MaximumIops.Type
    object MaximumNetworkCards extends Subtype[Int]
    type MaximumNetworkCards =
      zio.aws.ec2.model.primitives.MaximumNetworkCards.Type
    object MaximumThroughputInMBps extends Subtype[Double]
    type MaximumThroughputInMBps =
      zio.aws.ec2.model.primitives.MaximumThroughputInMBps.Type
    object MemorySize extends Subtype[Long]
    type MemorySize = zio.aws.ec2.model.primitives.MemorySize.Type
    object MillisecondDateTime extends Subtype[Instant]
    type MillisecondDateTime =
      zio.aws.ec2.model.primitives.MillisecondDateTime.Type
    object NatGatewayId extends Subtype[String]
    type NatGatewayId = zio.aws.ec2.model.primitives.NatGatewayId.Type
    object NetmaskLength extends Subtype[Int]
    type NetmaskLength = zio.aws.ec2.model.primitives.NetmaskLength.Type
    object NetworkAclAssociationId extends Subtype[String]
    type NetworkAclAssociationId =
      zio.aws.ec2.model.primitives.NetworkAclAssociationId.Type
    object NetworkAclId extends Subtype[String]
    type NetworkAclId = zio.aws.ec2.model.primitives.NetworkAclId.Type
    object NetworkCardIndex extends Subtype[Int]
    type NetworkCardIndex = zio.aws.ec2.model.primitives.NetworkCardIndex.Type
    object NetworkInsightsAccessScopeAnalysisId extends Subtype[String]
    type NetworkInsightsAccessScopeAnalysisId =
      zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeAnalysisId.Type
    object NetworkInsightsAccessScopeId extends Subtype[String]
    type NetworkInsightsAccessScopeId =
      zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId.Type
    object NetworkInsightsAnalysisId extends Subtype[String]
    type NetworkInsightsAnalysisId =
      zio.aws.ec2.model.primitives.NetworkInsightsAnalysisId.Type
    object NetworkInsightsMaxResults extends Subtype[Int]
    type NetworkInsightsMaxResults =
      zio.aws.ec2.model.primitives.NetworkInsightsMaxResults.Type
    object NetworkInsightsPathId extends Subtype[String]
    type NetworkInsightsPathId =
      zio.aws.ec2.model.primitives.NetworkInsightsPathId.Type
    object NetworkInsightsResourceId extends Subtype[String]
    type NetworkInsightsResourceId =
      zio.aws.ec2.model.primitives.NetworkInsightsResourceId.Type
    object NetworkInterfaceAttachmentId extends Subtype[String]
    type NetworkInterfaceAttachmentId =
      zio.aws.ec2.model.primitives.NetworkInterfaceAttachmentId.Type
    object NetworkInterfaceId extends Subtype[String]
    type NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId.Type
    object NetworkInterfacePermissionId extends Subtype[String]
    type NetworkInterfacePermissionId =
      zio.aws.ec2.model.primitives.NetworkInterfacePermissionId.Type
    object NetworkPerformance extends Subtype[String]
    type NetworkPerformance =
      zio.aws.ec2.model.primitives.NetworkPerformance.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.ec2.model.primitives.NextToken.Type
    object OfferingId extends Subtype[String]
    type OfferingId = zio.aws.ec2.model.primitives.OfferingId.Type
    object OutpostArn extends Subtype[String]
    type OutpostArn = zio.aws.ec2.model.primitives.OutpostArn.Type
    object PlacementGroupArn extends Subtype[String]
    type PlacementGroupArn = zio.aws.ec2.model.primitives.PlacementGroupArn.Type
    object PlacementGroupId extends Subtype[String]
    type PlacementGroupId = zio.aws.ec2.model.primitives.PlacementGroupId.Type
    object PlacementGroupName extends Subtype[String]
    type PlacementGroupName =
      zio.aws.ec2.model.primitives.PlacementGroupName.Type
    object PoolMaxResults extends Subtype[Int]
    type PoolMaxResults = zio.aws.ec2.model.primitives.PoolMaxResults.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.ec2.model.primitives.Port.Type
    object PrefixListMaxResults extends Subtype[Int]
    type PrefixListMaxResults =
      zio.aws.ec2.model.primitives.PrefixListMaxResults.Type
    object PrefixListResourceId extends Subtype[String]
    type PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId.Type
    object ProcessorSustainedClockSpeed extends Subtype[Double]
    type ProcessorSustainedClockSpeed =
      zio.aws.ec2.model.primitives.ProcessorSustainedClockSpeed.Type
    object PublicIpAddress extends Subtype[String]
    type PublicIpAddress = zio.aws.ec2.model.primitives.PublicIpAddress.Type
    object RamdiskId extends Subtype[String]
    type RamdiskId = zio.aws.ec2.model.primitives.RamdiskId.Type
    object ReplaceRootVolumeTaskId extends Subtype[String]
    type ReplaceRootVolumeTaskId =
      zio.aws.ec2.model.primitives.ReplaceRootVolumeTaskId.Type
    object ReservationId extends Subtype[String]
    type ReservationId = zio.aws.ec2.model.primitives.ReservationId.Type
    object ReservedInstancesListingId extends Subtype[String]
    type ReservedInstancesListingId =
      zio.aws.ec2.model.primitives.ReservedInstancesListingId.Type
    object ReservedInstancesModificationId extends Subtype[String]
    type ReservedInstancesModificationId =
      zio.aws.ec2.model.primitives.ReservedInstancesModificationId.Type
    object ReservedInstancesOfferingId extends Subtype[String]
    type ReservedInstancesOfferingId =
      zio.aws.ec2.model.primitives.ReservedInstancesOfferingId.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.ec2.model.primitives.ResourceArn.Type
    object RestoreSnapshotTierRequestTemporaryRestoreDays extends Subtype[Int]
    type RestoreSnapshotTierRequestTemporaryRestoreDays =
      zio.aws.ec2.model.primitives.RestoreSnapshotTierRequestTemporaryRestoreDays.Type
    object ResultRange extends Subtype[Int]
    type ResultRange = zio.aws.ec2.model.primitives.ResultRange.Type
    object RouteGatewayId extends Subtype[String]
    type RouteGatewayId = zio.aws.ec2.model.primitives.RouteGatewayId.Type
    object RouteTableAssociationId extends Subtype[String]
    type RouteTableAssociationId =
      zio.aws.ec2.model.primitives.RouteTableAssociationId.Type
    object RouteTableId extends Subtype[String]
    type RouteTableId = zio.aws.ec2.model.primitives.RouteTableId.Type
    object RunInstancesUserData extends Subtype[String]
    type RunInstancesUserData =
      zio.aws.ec2.model.primitives.RunInstancesUserData.Type
    object ScheduledInstanceId extends Subtype[String]
    type ScheduledInstanceId =
      zio.aws.ec2.model.primitives.ScheduledInstanceId.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId = zio.aws.ec2.model.primitives.SecurityGroupId.Type
    object SecurityGroupName extends Subtype[String]
    type SecurityGroupName = zio.aws.ec2.model.primitives.SecurityGroupName.Type
    object SecurityGroupRuleId extends Subtype[String]
    type SecurityGroupRuleId =
      zio.aws.ec2.model.primitives.SecurityGroupRuleId.Type
    object SensitiveUserData extends Subtype[String]
    type SensitiveUserData = zio.aws.ec2.model.primitives.SensitiveUserData.Type
    object SnapshotId extends Subtype[String]
    type SnapshotId = zio.aws.ec2.model.primitives.SnapshotId.Type
    object SpotFleetRequestId extends Subtype[String]
    type SpotFleetRequestId =
      zio.aws.ec2.model.primitives.SpotFleetRequestId.Type
    object SpotInstanceRequestId extends Subtype[String]
    type SpotInstanceRequestId =
      zio.aws.ec2.model.primitives.SpotInstanceRequestId.Type
    object SpotPlacementScoresMaxResults extends Subtype[Int]
    type SpotPlacementScoresMaxResults =
      zio.aws.ec2.model.primitives.SpotPlacementScoresMaxResults.Type
    object SpotPlacementScoresTargetCapacity extends Subtype[Int]
    type SpotPlacementScoresTargetCapacity =
      zio.aws.ec2.model.primitives.SpotPlacementScoresTargetCapacity.Type
    type StringType = String
    object SubnetCidrAssociationId extends Subtype[String]
    type SubnetCidrAssociationId =
      zio.aws.ec2.model.primitives.SubnetCidrAssociationId.Type
    object SubnetCidrReservationId extends Subtype[String]
    type SubnetCidrReservationId =
      zio.aws.ec2.model.primitives.SubnetCidrReservationId.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.ec2.model.primitives.SubnetId.Type
    object TaggableResourceId extends Subtype[String]
    type TaggableResourceId =
      zio.aws.ec2.model.primitives.TaggableResourceId.Type
    object ThreadsPerCore extends Subtype[Int]
    type ThreadsPerCore = zio.aws.ec2.model.primitives.ThreadsPerCore.Type
    object TotalFpgaMemory extends Subtype[Int]
    type TotalFpgaMemory = zio.aws.ec2.model.primitives.TotalFpgaMemory.Type
    object TotalGpuMemory extends Subtype[Int]
    type TotalGpuMemory = zio.aws.ec2.model.primitives.TotalGpuMemory.Type
    object TrafficMirrorFilterId extends Subtype[String]
    type TrafficMirrorFilterId =
      zio.aws.ec2.model.primitives.TrafficMirrorFilterId.Type
    object TrafficMirrorFilterRuleId extends Subtype[String]
    type TrafficMirrorFilterRuleId =
      zio.aws.ec2.model.primitives.TrafficMirrorFilterRuleId.Type
    object TrafficMirrorSessionId extends Subtype[String]
    type TrafficMirrorSessionId =
      zio.aws.ec2.model.primitives.TrafficMirrorSessionId.Type
    object TrafficMirrorTargetId extends Subtype[String]
    type TrafficMirrorTargetId =
      zio.aws.ec2.model.primitives.TrafficMirrorTargetId.Type
    object TrafficMirroringMaxResults extends Subtype[Int]
    type TrafficMirroringMaxResults =
      zio.aws.ec2.model.primitives.TrafficMirroringMaxResults.Type
    object TransitAssociationGatewayId extends Subtype[String]
    type TransitAssociationGatewayId =
      zio.aws.ec2.model.primitives.TransitAssociationGatewayId.Type
    object TransitGatewayAttachmentId extends Subtype[String]
    type TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives.TransitGatewayAttachmentId.Type
    object TransitGatewayConnectPeerId extends Subtype[String]
    type TransitGatewayConnectPeerId =
      zio.aws.ec2.model.primitives.TransitGatewayConnectPeerId.Type
    object TransitGatewayId extends Subtype[String]
    type TransitGatewayId = zio.aws.ec2.model.primitives.TransitGatewayId.Type
    object TransitGatewayMaxResults extends Subtype[Int]
    type TransitGatewayMaxResults =
      zio.aws.ec2.model.primitives.TransitGatewayMaxResults.Type
    object TransitGatewayMulticastDomainId extends Subtype[String]
    type TransitGatewayMulticastDomainId =
      zio.aws.ec2.model.primitives.TransitGatewayMulticastDomainId.Type
    object TransitGatewayPolicyTableId extends Subtype[String]
    type TransitGatewayPolicyTableId =
      zio.aws.ec2.model.primitives.TransitGatewayPolicyTableId.Type
    object TransitGatewayRouteTableAnnouncementId extends Subtype[String]
    type TransitGatewayRouteTableAnnouncementId =
      zio.aws.ec2.model.primitives.TransitGatewayRouteTableAnnouncementId.Type
    object TransitGatewayRouteTableId extends Subtype[String]
    type TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives.TransitGatewayRouteTableId.Type
    object TrunkInterfaceAssociationId extends Subtype[String]
    type TrunkInterfaceAssociationId =
      zio.aws.ec2.model.primitives.TrunkInterfaceAssociationId.Type
    object VCpuCount extends Subtype[Int]
    type VCpuCount = zio.aws.ec2.model.primitives.VCpuCount.Type
    object VersionDescription extends Subtype[String]
    type VersionDescription =
      zio.aws.ec2.model.primitives.VersionDescription.Type
    object VolumeId extends Subtype[String]
    type VolumeId = zio.aws.ec2.model.primitives.VolumeId.Type
    object VpcCidrAssociationId extends Subtype[String]
    type VpcCidrAssociationId =
      zio.aws.ec2.model.primitives.VpcCidrAssociationId.Type
    object VpcEndpointId extends Subtype[String]
    type VpcEndpointId = zio.aws.ec2.model.primitives.VpcEndpointId.Type
    object VpcEndpointServiceId extends Subtype[String]
    type VpcEndpointServiceId =
      zio.aws.ec2.model.primitives.VpcEndpointServiceId.Type
    object VpcFlowLogId extends Subtype[String]
    type VpcFlowLogId = zio.aws.ec2.model.primitives.VpcFlowLogId.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.ec2.model.primitives.VpcId.Type
    object VpcPeeringConnectionId extends Subtype[String]
    type VpcPeeringConnectionId =
      zio.aws.ec2.model.primitives.VpcPeeringConnectionId.Type
    object VpnConnectionDeviceSampleConfiguration extends Subtype[String]
    type VpnConnectionDeviceSampleConfiguration =
      zio.aws.ec2.model.primitives.VpnConnectionDeviceSampleConfiguration.Type
    object VpnConnectionDeviceTypeId extends Subtype[String]
    type VpnConnectionDeviceTypeId =
      zio.aws.ec2.model.primitives.VpnConnectionDeviceTypeId.Type
    object VpnConnectionId extends Subtype[String]
    type VpnConnectionId = zio.aws.ec2.model.primitives.VpnConnectionId.Type
    object VpnGatewayId extends Subtype[String]
    type VpnGatewayId = zio.aws.ec2.model.primitives.VpnGatewayId.Type
  }
  type AcceleratorManufacturerSet =
    List[zio.aws.ec2.model.AcceleratorManufacturer]
  type AcceleratorNameSet = List[zio.aws.ec2.model.AcceleratorName]
  type AcceleratorTypeSet = List[zio.aws.ec2.model.AcceleratorType]
  type AccessScopeAnalysisFindingList =
    List[zio.aws.ec2.model.AccessScopeAnalysisFinding]
  type AccessScopePathList = List[zio.aws.ec2.model.AccessScopePath]
  type AccessScopePathListRequest =
    List[zio.aws.ec2.model.AccessScopePathRequest]
  type AccountAttributeList = List[zio.aws.ec2.model.AccountAttribute]
  type AccountAttributeNameStringList =
    List[zio.aws.ec2.model.AccountAttributeName]
  type AccountAttributeValueList = List[zio.aws.ec2.model.AccountAttributeValue]
  type ActiveInstanceSet = List[zio.aws.ec2.model.ActiveInstance]
  type AddIpamOperatingRegionSet =
    List[zio.aws.ec2.model.AddIpamOperatingRegion]
  type AddPrefixListEntries = List[zio.aws.ec2.model.AddPrefixListEntry]
  type AddedPrincipalSet = List[zio.aws.ec2.model.AddedPrincipal]
  type AdditionalDetailList = List[zio.aws.ec2.model.AdditionalDetail]
  type AddressList = List[zio.aws.ec2.model.Address]
  type AddressSet = List[zio.aws.ec2.model.AddressAttribute]
  type AllocationIdList = List[AllocationId]
  type AllocationIds = List[AllocationId]
  type AllowedPrincipalSet = List[zio.aws.ec2.model.AllowedPrincipal]
  type AlternatePathHintList = List[zio.aws.ec2.model.AlternatePathHint]
  type AnalysisComponentList = List[zio.aws.ec2.model.AnalysisComponent]
  type ArchitectureTypeList = List[zio.aws.ec2.model.ArchitectureType]
  type ArchitectureTypeSet = List[zio.aws.ec2.model.ArchitectureType]
  type ArnList = List[ResourceArn]
  type AssignedPrivateIpAddressList =
    List[zio.aws.ec2.model.AssignedPrivateIpAddress]
  type AssociatedRolesList = List[zio.aws.ec2.model.AssociatedRole]
  type AssociatedTargetNetworkSet =
    List[zio.aws.ec2.model.AssociatedTargetNetwork]
  type AssociationIdList = List[IamInstanceProfileAssociationId]
  type AthenaIntegrationsSet = List[zio.aws.ec2.model.AthenaIntegration]
  type AuthorizationRuleSet = List[zio.aws.ec2.model.AuthorizationRule]
  type AvailabilityZoneList = List[zio.aws.ec2.model.AvailabilityZone]
  type AvailabilityZoneMessageList =
    List[zio.aws.ec2.model.AvailabilityZoneMessage]
  type AvailabilityZoneStringList = List[String]
  type AvailableInstanceCapacityList = List[zio.aws.ec2.model.InstanceCapacity]
  type BillingProductList = List[String]
  type BlockDeviceMappingList = List[zio.aws.ec2.model.BlockDeviceMapping]
  type BlockDeviceMappingRequestList =
    List[zio.aws.ec2.model.BlockDeviceMapping]
  type BootModeTypeList = List[zio.aws.ec2.model.BootModeType]
  type BundleIdStringList = List[BundleId]
  type BundleTaskList = List[zio.aws.ec2.model.BundleTask]
  type ByoipCidrSet = List[zio.aws.ec2.model.ByoipCidr]
  type CancelSpotFleetRequestsErrorSet =
    List[zio.aws.ec2.model.CancelSpotFleetRequestsErrorItem]
  type CancelSpotFleetRequestsSuccessSet =
    List[zio.aws.ec2.model.CancelSpotFleetRequestsSuccessItem]
  type CancelledSpotInstanceRequestList =
    List[zio.aws.ec2.model.CancelledSpotInstanceRequest]
  type CapacityAllocations = List[zio.aws.ec2.model.CapacityAllocation]
  type CapacityReservationFleetCancellationStateSet =
    List[zio.aws.ec2.model.CapacityReservationFleetCancellationState]
  type CapacityReservationFleetIdSet = List[CapacityReservationFleetId]
  type CapacityReservationFleetSet =
    List[zio.aws.ec2.model.CapacityReservationFleet]
  type CapacityReservationGroupSet =
    List[zio.aws.ec2.model.CapacityReservationGroup]
  type CapacityReservationIdSet = List[CapacityReservationId]
  type CapacityReservationSet = List[zio.aws.ec2.model.CapacityReservation]
  type CarrierGatewayIdSet = List[CarrierGatewayId]
  type CarrierGatewaySet = List[zio.aws.ec2.model.CarrierGateway]
  type CidrBlockSet = List[zio.aws.ec2.model.CidrBlock]
  type ClassicLinkDnsSupportList = List[zio.aws.ec2.model.ClassicLinkDnsSupport]
  type ClassicLinkInstanceList = List[zio.aws.ec2.model.ClassicLinkInstance]
  type ClassicLoadBalancers = List[zio.aws.ec2.model.ClassicLoadBalancer]
  type ClientVpnAuthenticationList =
    List[zio.aws.ec2.model.ClientVpnAuthentication]
  type ClientVpnAuthenticationRequestList =
    List[zio.aws.ec2.model.ClientVpnAuthenticationRequest]
  type ClientVpnConnectionSet = List[zio.aws.ec2.model.ClientVpnConnection]
  type ClientVpnEndpointIdList = List[ClientVpnEndpointId]
  type ClientVpnRouteSet = List[zio.aws.ec2.model.ClientVpnRoute]
  type ClientVpnSecurityGroupIdSet = List[SecurityGroupId]
  type CoipAddressUsageSet = List[zio.aws.ec2.model.CoipAddressUsage]
  type CoipPoolIdSet = List[Ipv4PoolCoipId]
  type CoipPoolSet = List[zio.aws.ec2.model.CoipPool]
  type ConnectionNotificationIdsList = List[ConnectionNotificationId]
  type ConnectionNotificationSet =
    List[zio.aws.ec2.model.ConnectionNotification]
  type ConversionIdStringList = List[ConversionTaskId]
  type CoreCountList = List[CoreCount]
  type CpuManufacturerSet = List[zio.aws.ec2.model.CpuManufacturer]
  type CreateFleetErrorsSet = List[zio.aws.ec2.model.CreateFleetError]
  type CreateFleetInstancesSet = List[zio.aws.ec2.model.CreateFleetInstance]
  type CreateVolumePermissionList =
    List[zio.aws.ec2.model.CreateVolumePermission]
  type CustomerGatewayIdStringList = List[CustomerGatewayId]
  type CustomerGatewayList = List[zio.aws.ec2.model.CustomerGateway]
  type DedicatedHostIdList = List[DedicatedHostId]
  type DeleteFleetErrorSet = List[zio.aws.ec2.model.DeleteFleetErrorItem]
  type DeleteFleetSuccessSet = List[zio.aws.ec2.model.DeleteFleetSuccessItem]
  type DeleteLaunchTemplateVersionsResponseErrorSet =
    List[zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem]
  type DeleteLaunchTemplateVersionsResponseSuccessSet =
    List[zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem]
  type DeleteQueuedReservedInstancesIdList = List[ReservationId]
  type DeprovisionedAddressSet = List[String]
  type DescribeConversionTaskList = List[zio.aws.ec2.model.ConversionTask]
  type DescribeFastLaunchImagesSuccessSet =
    List[zio.aws.ec2.model.DescribeFastLaunchImagesSuccessItem]
  type DescribeFastSnapshotRestoreSuccessSet =
    List[zio.aws.ec2.model.DescribeFastSnapshotRestoreSuccessItem]
  type DescribeFleetsErrorSet = List[zio.aws.ec2.model.DescribeFleetError]
  type DescribeFleetsInstancesSet =
    List[zio.aws.ec2.model.DescribeFleetsInstances]
  type DhcpConfigurationList = List[zio.aws.ec2.model.DhcpConfiguration]
  type DhcpConfigurationValueList = List[zio.aws.ec2.model.AttributeValue]
  type DhcpOptionsIdStringList = List[DhcpOptionsId]
  type DhcpOptionsList = List[zio.aws.ec2.model.DhcpOptions]
  type DisableFastSnapshotRestoreErrorSet =
    List[zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem]
  type DisableFastSnapshotRestoreStateErrorSet =
    List[zio.aws.ec2.model.DisableFastSnapshotRestoreStateErrorItem]
  type DisableFastSnapshotRestoreSuccessSet =
    List[zio.aws.ec2.model.DisableFastSnapshotRestoreSuccessItem]
  type DiskImageList = List[zio.aws.ec2.model.DiskImage]
  type DiskInfoList = List[zio.aws.ec2.model.DiskInfo]
  type DnsEntrySet = List[zio.aws.ec2.model.DnsEntry]
  type EgressOnlyInternetGatewayIdList = List[EgressOnlyInternetGatewayId]
  type EgressOnlyInternetGatewayList =
    List[zio.aws.ec2.model.EgressOnlyInternetGateway]
  type ElasticGpuAssociationList = List[zio.aws.ec2.model.ElasticGpuAssociation]
  type ElasticGpuIdSet = List[ElasticGpuId]
  type ElasticGpuSet = List[zio.aws.ec2.model.ElasticGpus]
  type ElasticGpuSpecificationList =
    List[zio.aws.ec2.model.ElasticGpuSpecification]
  type ElasticGpuSpecificationResponseList =
    List[zio.aws.ec2.model.ElasticGpuSpecificationResponse]
  type ElasticGpuSpecifications =
    List[zio.aws.ec2.model.ElasticGpuSpecification]
  type ElasticInferenceAcceleratorAssociationList =
    List[zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation]
  type ElasticInferenceAccelerators =
    List[zio.aws.ec2.model.ElasticInferenceAccelerator]
  type EnableFastSnapshotRestoreErrorSet =
    List[zio.aws.ec2.model.EnableFastSnapshotRestoreErrorItem]
  type EnableFastSnapshotRestoreStateErrorSet =
    List[zio.aws.ec2.model.EnableFastSnapshotRestoreStateErrorItem]
  type EnableFastSnapshotRestoreSuccessSet =
    List[zio.aws.ec2.model.EnableFastSnapshotRestoreSuccessItem]
  type EndpointSet = List[zio.aws.ec2.model.ClientVpnEndpoint]
  type ErrorSet = List[zio.aws.ec2.model.ValidationError]
  type ExcludedInstanceTypeSet = List[ExcludedInstanceType]
  type ExecutableByStringList = List[String]
  type ExplanationList = List[zio.aws.ec2.model.Explanation]
  type ExportImageTaskIdList = List[ExportImageTaskId]
  type ExportImageTaskList = List[zio.aws.ec2.model.ExportImageTask]
  type ExportTaskIdStringList = List[ExportTaskId]
  type ExportTaskList = List[zio.aws.ec2.model.ExportTask]
  type FailedCapacityReservationFleetCancellationResultSet =
    List[zio.aws.ec2.model.FailedCapacityReservationFleetCancellationResult]
  type FailedQueuedPurchaseDeletionSet =
    List[zio.aws.ec2.model.FailedQueuedPurchaseDeletion]
  type FastLaunchImageIdList = List[ImageId]
  type FilterList = List[zio.aws.ec2.model.Filter]
  type FleetCapacityReservationSet =
    List[zio.aws.ec2.model.FleetCapacityReservation]
  type FleetIdSet = List[FleetId]
  type FleetLaunchTemplateConfigList =
    List[zio.aws.ec2.model.FleetLaunchTemplateConfig]
  type FleetLaunchTemplateConfigListRequest =
    List[zio.aws.ec2.model.FleetLaunchTemplateConfigRequest]
  type FleetLaunchTemplateOverridesList =
    List[zio.aws.ec2.model.FleetLaunchTemplateOverrides]
  type FleetLaunchTemplateOverridesListRequest =
    List[zio.aws.ec2.model.FleetLaunchTemplateOverridesRequest]
  type FleetSet = List[zio.aws.ec2.model.FleetData]
  type FlowLogIdList = List[VpcFlowLogId]
  type FlowLogResourceIds = List[FlowLogResourceId]
  type FlowLogSet = List[zio.aws.ec2.model.FlowLog]
  type FpgaDeviceInfoList = List[zio.aws.ec2.model.FpgaDeviceInfo]
  type FpgaImageIdList = List[FpgaImageId]
  type FpgaImageList = List[zio.aws.ec2.model.FpgaImage]
  type GpuDeviceInfoList = List[zio.aws.ec2.model.GpuDeviceInfo]
  type GroupIdStringList = List[SecurityGroupId]
  type GroupIdentifierList = List[zio.aws.ec2.model.GroupIdentifier]
  type GroupIdentifierSet = List[zio.aws.ec2.model.SecurityGroupIdentifier]
  type GroupIds = List[SecurityGroupId]
  type GroupNameStringList = List[SecurityGroupName]
  type HistoryRecordSet = List[zio.aws.ec2.model.HistoryRecordEntry]
  type HistoryRecords = List[zio.aws.ec2.model.HistoryRecord]
  type HostInstanceList = List[zio.aws.ec2.model.HostInstance]
  type HostList = List[zio.aws.ec2.model.Host]
  type HostOfferingSet = List[zio.aws.ec2.model.HostOffering]
  type HostReservationIdSet = List[HostReservationId]
  type HostReservationSet = List[zio.aws.ec2.model.HostReservation]
  type IKEVersionsList = List[zio.aws.ec2.model.IKEVersionsListValue]
  type IKEVersionsRequestList =
    List[zio.aws.ec2.model.IKEVersionsRequestListValue]
  type IamInstanceProfileAssociationSet =
    List[zio.aws.ec2.model.IamInstanceProfileAssociation]
  type IdFormatList = List[zio.aws.ec2.model.IdFormat]
  type ImageDiskContainerList = List[zio.aws.ec2.model.ImageDiskContainer]
  type ImageIdList = List[ImageId]
  type ImageIdStringList = List[ImageId]
  type ImageList = List[zio.aws.ec2.model.Image]
  type ImageRecycleBinInfoList = List[zio.aws.ec2.model.ImageRecycleBinInfo]
  type ImportImageLicenseSpecificationListRequest =
    List[zio.aws.ec2.model.ImportImageLicenseConfigurationRequest]
  type ImportImageLicenseSpecificationListResponse =
    List[zio.aws.ec2.model.ImportImageLicenseConfigurationResponse]
  type ImportImageTaskList = List[zio.aws.ec2.model.ImportImageTask]
  type ImportInstanceVolumeDetailSet =
    List[zio.aws.ec2.model.ImportInstanceVolumeDetailItem]
  type ImportSnapshotTaskIdList = List[ImportSnapshotTaskId]
  type ImportSnapshotTaskList = List[zio.aws.ec2.model.ImportSnapshotTask]
  type ImportTaskIdList = List[ImportImageTaskId]
  type InferenceDeviceInfoList = List[zio.aws.ec2.model.InferenceDeviceInfo]
  type InsideCidrBlocksStringList = List[String]
  type InstanceBlockDeviceMappingList =
    List[zio.aws.ec2.model.InstanceBlockDeviceMapping]
  type InstanceBlockDeviceMappingSpecificationList =
    List[zio.aws.ec2.model.InstanceBlockDeviceMappingSpecification]
  type InstanceCountList = List[zio.aws.ec2.model.InstanceCount]
  type InstanceCreditSpecificationList =
    List[zio.aws.ec2.model.InstanceCreditSpecification]
  type InstanceCreditSpecificationListRequest =
    List[zio.aws.ec2.model.InstanceCreditSpecificationRequest]
  type InstanceEventWindowIdSet = List[InstanceEventWindowId]
  type InstanceEventWindowSet = List[zio.aws.ec2.model.InstanceEventWindow]
  type InstanceEventWindowTimeRangeList =
    List[zio.aws.ec2.model.InstanceEventWindowTimeRange]
  type InstanceEventWindowTimeRangeRequestSet =
    List[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest]
  type InstanceGenerationSet = List[zio.aws.ec2.model.InstanceGeneration]
  type InstanceIdList = List[InstanceId]
  type InstanceIdSet = List[InstanceId]
  type InstanceIdStringList = List[InstanceId]
  type InstanceIdsSet = List[InstanceId]
  type InstanceIpv4PrefixList = List[zio.aws.ec2.model.InstanceIpv4Prefix]
  type InstanceIpv6AddressList = List[zio.aws.ec2.model.InstanceIpv6Address]
  type InstanceIpv6AddressListRequest =
    List[zio.aws.ec2.model.InstanceIpv6AddressRequest]
  type InstanceIpv6PrefixList = List[zio.aws.ec2.model.InstanceIpv6Prefix]
  type InstanceList = List[zio.aws.ec2.model.Instance]
  type InstanceMonitoringList = List[zio.aws.ec2.model.InstanceMonitoring]
  type InstanceNetworkInterfaceList =
    List[zio.aws.ec2.model.InstanceNetworkInterface]
  type InstanceNetworkInterfaceSpecificationList =
    List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification]
  type InstancePrivateIpAddressList =
    List[zio.aws.ec2.model.InstancePrivateIpAddress]
  type InstanceStateChangeList = List[zio.aws.ec2.model.InstanceStateChange]
  type InstanceStatusDetailsList = List[zio.aws.ec2.model.InstanceStatusDetails]
  type InstanceStatusEventList = List[zio.aws.ec2.model.InstanceStatusEvent]
  type InstanceStatusList = List[zio.aws.ec2.model.InstanceStatus]
  type InstanceTagKeySet = List[String]
  type InstanceTypeInfoFromInstanceRequirementsSet =
    List[zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements]
  type InstanceTypeInfoList = List[zio.aws.ec2.model.InstanceTypeInfo]
  type InstanceTypeList = List[zio.aws.ec2.model.InstanceType]
  type InstanceTypeOfferingsList = List[zio.aws.ec2.model.InstanceTypeOffering]
  type InstanceTypes = List[String]
  type InstanceUsageSet = List[zio.aws.ec2.model.InstanceUsage]
  type InternetGatewayAttachmentList =
    List[zio.aws.ec2.model.InternetGatewayAttachment]
  type InternetGatewayIdList = List[InternetGatewayId]
  type InternetGatewayList = List[zio.aws.ec2.model.InternetGateway]
  type IpAddressList = List[IpAddress]
  type IpPermissionList = List[zio.aws.ec2.model.IpPermission]
  type IpPrefixList = List[String]
  type IpRangeList = List[zio.aws.ec2.model.IpRange]
  type IpRanges = List[String]
  type IpamAddressHistoryRecordSet =
    List[zio.aws.ec2.model.IpamAddressHistoryRecord]
  type IpamOperatingRegionSet = List[zio.aws.ec2.model.IpamOperatingRegion]
  type IpamPoolAllocationDisallowedCidrs = List[String]
  type IpamPoolAllocationSet = List[zio.aws.ec2.model.IpamPoolAllocation]
  type IpamPoolCidrSet = List[zio.aws.ec2.model.IpamPoolCidr]
  type IpamPoolSet = List[zio.aws.ec2.model.IpamPool]
  type IpamResourceCidrSet = List[zio.aws.ec2.model.IpamResourceCidr]
  type IpamResourceTagList = List[zio.aws.ec2.model.IpamResourceTag]
  type IpamScopeSet = List[zio.aws.ec2.model.IpamScope]
  type IpamSet = List[zio.aws.ec2.model.Ipam]
  type Ipv4PrefixList = List[zio.aws.ec2.model.Ipv4PrefixSpecificationRequest]
  type Ipv4PrefixListResponse =
    List[zio.aws.ec2.model.Ipv4PrefixSpecificationResponse]
  type Ipv4PrefixesList = List[zio.aws.ec2.model.Ipv4PrefixSpecification]
  type Ipv6AddressList = List[String]
  type Ipv6CidrAssociationSet = List[zio.aws.ec2.model.Ipv6CidrAssociation]
  type Ipv6CidrBlockSet = List[zio.aws.ec2.model.Ipv6CidrBlock]
  type Ipv6PoolIdList = List[Ipv6PoolEc2Id]
  type Ipv6PoolSet = List[zio.aws.ec2.model.Ipv6Pool]
  type Ipv6PrefixList = List[zio.aws.ec2.model.Ipv6PrefixSpecificationRequest]
  type Ipv6PrefixListResponse =
    List[zio.aws.ec2.model.Ipv6PrefixSpecificationResponse]
  type Ipv6PrefixesList = List[zio.aws.ec2.model.Ipv6PrefixSpecification]
  type Ipv6RangeList = List[zio.aws.ec2.model.Ipv6Range]
  type KeyNameStringList = List[KeyPairName]
  type KeyPairIdStringList = List[KeyPairId]
  type KeyPairList = List[zio.aws.ec2.model.KeyPairInfo]
  type LaunchPermissionList = List[zio.aws.ec2.model.LaunchPermission]
  type LaunchSpecsList = List[zio.aws.ec2.model.SpotFleetLaunchSpecification]
  type LaunchTemplateBlockDeviceMappingList =
    List[zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping]
  type LaunchTemplateBlockDeviceMappingRequestList =
    List[zio.aws.ec2.model.LaunchTemplateBlockDeviceMappingRequest]
  type LaunchTemplateConfigList = List[zio.aws.ec2.model.LaunchTemplateConfig]
  type LaunchTemplateElasticInferenceAcceleratorList =
    List[zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator]
  type LaunchTemplateElasticInferenceAcceleratorResponseList =
    List[zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse]
  type LaunchTemplateIdStringList = List[LaunchTemplateId]
  type LaunchTemplateInstanceNetworkInterfaceSpecificationList =
    List[zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification]
  type LaunchTemplateInstanceNetworkInterfaceSpecificationRequestList = List[
    zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest
  ]
  type LaunchTemplateLicenseList =
    List[zio.aws.ec2.model.LaunchTemplateLicenseConfiguration]
  type LaunchTemplateLicenseSpecificationListRequest =
    List[zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest]
  type LaunchTemplateNameStringList = List[LaunchTemplateName]
  type LaunchTemplateOverridesList =
    List[zio.aws.ec2.model.LaunchTemplateOverrides]
  type LaunchTemplateSet = List[zio.aws.ec2.model.LaunchTemplate]
  type LaunchTemplateTagSpecificationList =
    List[zio.aws.ec2.model.LaunchTemplateTagSpecification]
  type LaunchTemplateTagSpecificationRequestList =
    List[zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest]
  type LaunchTemplateVersionSet = List[zio.aws.ec2.model.LaunchTemplateVersion]
  type LicenseList = List[zio.aws.ec2.model.LicenseConfiguration]
  type LicenseSpecificationListRequest =
    List[zio.aws.ec2.model.LicenseConfigurationRequest]
  type LoadPermissionList = List[zio.aws.ec2.model.LoadPermission]
  type LoadPermissionListRequest = List[zio.aws.ec2.model.LoadPermissionRequest]
  type LocalGatewayIdSet = List[LocalGatewayId]
  type LocalGatewayRouteList = List[zio.aws.ec2.model.LocalGatewayRoute]
  type LocalGatewayRouteTableIdSet = List[LocalGatewayRoutetableId]
  type LocalGatewayRouteTableSet =
    List[zio.aws.ec2.model.LocalGatewayRouteTable]
  type LocalGatewayRouteTableVirtualInterfaceGroupAssociationIdSet =
    List[LocalGatewayRouteTableVirtualInterfaceGroupAssociationId]
  type LocalGatewayRouteTableVirtualInterfaceGroupAssociationSet = List[
    zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
  ]
  type LocalGatewayRouteTableVpcAssociationIdSet =
    List[LocalGatewayRouteTableVpcAssociationId]
  type LocalGatewayRouteTableVpcAssociationSet =
    List[zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation]
  type LocalGatewaySet = List[zio.aws.ec2.model.LocalGateway]
  type LocalGatewayVirtualInterfaceGroupIdSet =
    List[LocalGatewayVirtualInterfaceGroupId]
  type LocalGatewayVirtualInterfaceGroupSet =
    List[zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup]
  type LocalGatewayVirtualInterfaceIdSet = List[LocalGatewayVirtualInterfaceId]
  type LocalGatewayVirtualInterfaceSet =
    List[zio.aws.ec2.model.LocalGatewayVirtualInterface]
  type LocalStorageTypeSet = List[zio.aws.ec2.model.LocalStorageType]
  type ManagedPrefixListSet = List[zio.aws.ec2.model.ManagedPrefixList]
  type MovingAddressStatusSet = List[zio.aws.ec2.model.MovingAddressStatus]
  type NatGatewayAddressList = List[zio.aws.ec2.model.NatGatewayAddress]
  type NatGatewayIdStringList = List[NatGatewayId]
  type NatGatewayList = List[zio.aws.ec2.model.NatGateway]
  type NetworkAclAssociationList = List[zio.aws.ec2.model.NetworkAclAssociation]
  type NetworkAclEntryList = List[zio.aws.ec2.model.NetworkAclEntry]
  type NetworkAclIdStringList = List[NetworkAclId]
  type NetworkAclList = List[zio.aws.ec2.model.NetworkAcl]
  type NetworkCardInfoList = List[zio.aws.ec2.model.NetworkCardInfo]
  type NetworkInsightsAccessScopeAnalysisIdList =
    List[NetworkInsightsAccessScopeAnalysisId]
  type NetworkInsightsAccessScopeAnalysisList =
    List[zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis]
  type NetworkInsightsAccessScopeIdList = List[NetworkInsightsAccessScopeId]
  type NetworkInsightsAccessScopeList =
    List[zio.aws.ec2.model.NetworkInsightsAccessScope]
  type NetworkInsightsAnalysisIdList = List[NetworkInsightsAnalysisId]
  type NetworkInsightsAnalysisList =
    List[zio.aws.ec2.model.NetworkInsightsAnalysis]
  type NetworkInsightsPathIdList = List[NetworkInsightsPathId]
  type NetworkInsightsPathList = List[zio.aws.ec2.model.NetworkInsightsPath]
  type NetworkInterfaceIdList = List[NetworkInterfaceId]
  type NetworkInterfaceIpv6AddressesList =
    List[zio.aws.ec2.model.NetworkInterfaceIpv6Address]
  type NetworkInterfaceList = List[zio.aws.ec2.model.NetworkInterface]
  type NetworkInterfacePermissionIdList = List[NetworkInterfacePermissionId]
  type NetworkInterfacePermissionList =
    List[zio.aws.ec2.model.NetworkInterfacePermission]
  type NetworkInterfacePrivateIpAddressList =
    List[zio.aws.ec2.model.NetworkInterfacePrivateIpAddress]
  type NewDhcpConfigurationList = List[zio.aws.ec2.model.NewDhcpConfiguration]
  type OccurrenceDayRequestSet = List[Integer]
  type OccurrenceDaySet = List[Integer]
  type OrganizationArnStringList = List[String]
  type OrganizationalUnitArnStringList = List[String]
  type OwnerStringList = List[String]
  type PathComponentList = List[zio.aws.ec2.model.PathComponent]
  type Phase1DHGroupNumbersList =
    List[zio.aws.ec2.model.Phase1DHGroupNumbersListValue]
  type Phase1DHGroupNumbersRequestList =
    List[zio.aws.ec2.model.Phase1DHGroupNumbersRequestListValue]
  type Phase1EncryptionAlgorithmsList =
    List[zio.aws.ec2.model.Phase1EncryptionAlgorithmsListValue]
  type Phase1EncryptionAlgorithmsRequestList =
    List[zio.aws.ec2.model.Phase1EncryptionAlgorithmsRequestListValue]
  type Phase1IntegrityAlgorithmsList =
    List[zio.aws.ec2.model.Phase1IntegrityAlgorithmsListValue]
  type Phase1IntegrityAlgorithmsRequestList =
    List[zio.aws.ec2.model.Phase1IntegrityAlgorithmsRequestListValue]
  type Phase2DHGroupNumbersList =
    List[zio.aws.ec2.model.Phase2DHGroupNumbersListValue]
  type Phase2DHGroupNumbersRequestList =
    List[zio.aws.ec2.model.Phase2DHGroupNumbersRequestListValue]
  type Phase2EncryptionAlgorithmsList =
    List[zio.aws.ec2.model.Phase2EncryptionAlgorithmsListValue]
  type Phase2EncryptionAlgorithmsRequestList =
    List[zio.aws.ec2.model.Phase2EncryptionAlgorithmsRequestListValue]
  type Phase2IntegrityAlgorithmsList =
    List[zio.aws.ec2.model.Phase2IntegrityAlgorithmsListValue]
  type Phase2IntegrityAlgorithmsRequestList =
    List[zio.aws.ec2.model.Phase2IntegrityAlgorithmsRequestListValue]
  type PlacementGroupIdStringList = List[PlacementGroupId]
  type PlacementGroupList = List[zio.aws.ec2.model.PlacementGroup]
  type PlacementGroupStrategyList =
    List[zio.aws.ec2.model.PlacementGroupStrategy]
  type PlacementGroupStringList = List[PlacementGroupName]
  type PoolCidrBlocksSet = List[zio.aws.ec2.model.PoolCidrBlock]
  type PortRangeList = List[zio.aws.ec2.model.PortRange]
  type PrefixListAssociationSet = List[zio.aws.ec2.model.PrefixListAssociation]
  type PrefixListEntrySet = List[zio.aws.ec2.model.PrefixListEntry]
  type PrefixListIdList = List[zio.aws.ec2.model.PrefixListId]
  type PrefixListIdSet = List[String]
  type PrefixListResourceIdStringList = List[PrefixListResourceId]
  type PrefixListSet = List[zio.aws.ec2.model.PrefixList]
  type PriceScheduleList = List[zio.aws.ec2.model.PriceSchedule]
  type PriceScheduleSpecificationList =
    List[zio.aws.ec2.model.PriceScheduleSpecification]
  type PricingDetailsList = List[zio.aws.ec2.model.PricingDetail]
  type PrincipalIdFormatList = List[zio.aws.ec2.model.PrincipalIdFormat]
  type PrivateDnsDetailsSet = List[zio.aws.ec2.model.PrivateDnsDetails]
  type PrivateIpAddressConfigSet =
    List[zio.aws.ec2.model.ScheduledInstancesPrivateIpAddressConfig]
  type PrivateIpAddressSpecificationList =
    List[zio.aws.ec2.model.PrivateIpAddressSpecification]
  type PrivateIpAddressStringList = List[String]
  type ProductCodeList = List[zio.aws.ec2.model.ProductCode]
  type ProductCodeStringList = List[String]
  type ProductDescriptionList = List[String]
  type PropagatingVgwList = List[zio.aws.ec2.model.PropagatingVgw]
  type ProtocolList = List[zio.aws.ec2.model.Protocol]
  type PublicIpStringList = List[String]
  type PublicIpv4PoolIdStringList = List[Ipv4PoolEc2Id]
  type PublicIpv4PoolRangeSet = List[zio.aws.ec2.model.PublicIpv4PoolRange]
  type PublicIpv4PoolSet = List[zio.aws.ec2.model.PublicIpv4Pool]
  type PurchaseRequestSet = List[zio.aws.ec2.model.PurchaseRequest]
  type PurchaseSet = List[zio.aws.ec2.model.Purchase]
  type PurchasedScheduledInstanceSet = List[zio.aws.ec2.model.ScheduledInstance]
  type ReasonCodesList = List[zio.aws.ec2.model.ReportInstanceReasonCodes]
  type RecurringChargesList = List[zio.aws.ec2.model.RecurringCharge]
  type RegionList = List[zio.aws.ec2.model.Region]
  type RegionNameStringList = List[String]
  type RegionNames = List[String]
  type RemoveIpamOperatingRegionSet =
    List[zio.aws.ec2.model.RemoveIpamOperatingRegion]
  type RemovePrefixListEntries = List[zio.aws.ec2.model.RemovePrefixListEntry]
  type ReplaceRootVolumeTaskIds = List[ReplaceRootVolumeTaskId]
  type ReplaceRootVolumeTasks = List[zio.aws.ec2.model.ReplaceRootVolumeTask]
  type RequestHostIdList = List[DedicatedHostId]
  type RequestHostIdSet = List[DedicatedHostId]
  type RequestInstanceTypeList = List[zio.aws.ec2.model.InstanceType]
  type RequestIpamResourceTagList =
    List[zio.aws.ec2.model.RequestIpamResourceTag]
  type RequestSpotLaunchSpecificationSecurityGroupIdList = List[SecurityGroupId]
  type RequestSpotLaunchSpecificationSecurityGroupList = List[String]
  type ReservationFleetInstanceSpecificationList =
    List[zio.aws.ec2.model.ReservationFleetInstanceSpecification]
  type ReservationList = List[zio.aws.ec2.model.Reservation]
  type ReservedInstanceIdSet = List[ReservationId]
  type ReservedInstanceReservationValueSet =
    List[zio.aws.ec2.model.ReservedInstanceReservationValue]
  type ReservedInstancesConfigurationList =
    List[zio.aws.ec2.model.ReservedInstancesConfiguration]
  type ReservedInstancesIdStringList = List[ReservationId]
  type ReservedInstancesList = List[zio.aws.ec2.model.ReservedInstances]
  type ReservedInstancesListingList =
    List[zio.aws.ec2.model.ReservedInstancesListing]
  type ReservedInstancesModificationIdStringList =
    List[ReservedInstancesModificationId]
  type ReservedInstancesModificationList =
    List[zio.aws.ec2.model.ReservedInstancesModification]
  type ReservedInstancesModificationResultList =
    List[zio.aws.ec2.model.ReservedInstancesModificationResult]
  type ReservedInstancesOfferingIdStringList = List[ReservedInstancesOfferingId]
  type ReservedInstancesOfferingList =
    List[zio.aws.ec2.model.ReservedInstancesOffering]
  type ReservedIntancesIds = List[zio.aws.ec2.model.ReservedInstancesId]
  type ResourceIdList = List[TaggableResourceId]
  type ResourceList = List[String]
  type ResponseHostIdList = List[String]
  type ResponseHostIdSet = List[String]
  type RestorableByStringList = List[String]
  type RootDeviceTypeList = List[zio.aws.ec2.model.RootDeviceType]
  type RouteList = List[zio.aws.ec2.model.Route]
  type RouteTableAssociationList = List[zio.aws.ec2.model.RouteTableAssociation]
  type RouteTableIdStringList = List[RouteTableId]
  type RouteTableList = List[zio.aws.ec2.model.RouteTable]
  type S3ObjectTagList = List[zio.aws.ec2.model.S3ObjectTag]
  type ScheduledInstanceAvailabilitySet =
    List[zio.aws.ec2.model.ScheduledInstanceAvailability]
  type ScheduledInstanceIdRequestSet = List[ScheduledInstanceId]
  type ScheduledInstanceSet = List[zio.aws.ec2.model.ScheduledInstance]
  type ScheduledInstancesBlockDeviceMappingSet =
    List[zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping]
  type ScheduledInstancesIpv6AddressList =
    List[zio.aws.ec2.model.ScheduledInstancesIpv6Address]
  type ScheduledInstancesNetworkInterfaceSet =
    List[zio.aws.ec2.model.ScheduledInstancesNetworkInterface]
  type ScheduledInstancesSecurityGroupIdSet = List[SecurityGroupId]
  type SecurityGroupIdStringList = List[SecurityGroupId]
  type SecurityGroupList = List[zio.aws.ec2.model.SecurityGroup]
  type SecurityGroupReferences = List[zio.aws.ec2.model.SecurityGroupReference]
  type SecurityGroupRuleDescriptionList =
    List[zio.aws.ec2.model.SecurityGroupRuleDescription]
  type SecurityGroupRuleIdList = List[String]
  type SecurityGroupRuleList = List[zio.aws.ec2.model.SecurityGroupRule]
  type SecurityGroupRuleUpdateList =
    List[zio.aws.ec2.model.SecurityGroupRuleUpdate]
  type SecurityGroupStringList = List[SecurityGroupName]
  type ServiceConfigurationSet = List[zio.aws.ec2.model.ServiceConfiguration]
  type ServiceDetailSet = List[zio.aws.ec2.model.ServiceDetail]
  type ServiceTypeDetailSet = List[zio.aws.ec2.model.ServiceTypeDetail]
  type SnapshotDetailList = List[zio.aws.ec2.model.SnapshotDetail]
  type SnapshotIdStringList = List[SnapshotId]
  type SnapshotList = List[zio.aws.ec2.model.Snapshot]
  type SnapshotRecycleBinInfoList =
    List[zio.aws.ec2.model.SnapshotRecycleBinInfo]
  type SnapshotSet = List[zio.aws.ec2.model.SnapshotInfo]
  type SnapshotTierStatusSet = List[zio.aws.ec2.model.SnapshotTierStatus]
  type SpotFleetRequestConfigSet =
    List[zio.aws.ec2.model.SpotFleetRequestConfig]
  type SpotFleetRequestIdList = List[SpotFleetRequestId]
  type SpotFleetTagSpecificationList =
    List[zio.aws.ec2.model.SpotFleetTagSpecification]
  type SpotInstanceRequestIdList = List[SpotInstanceRequestId]
  type SpotInstanceRequestList = List[zio.aws.ec2.model.SpotInstanceRequest]
  type SpotPlacementScores = List[zio.aws.ec2.model.SpotPlacementScore]
  type SpotPriceHistoryList = List[zio.aws.ec2.model.SpotPrice]
  type StaleIpPermissionSet = List[zio.aws.ec2.model.StaleIpPermission]
  type StaleSecurityGroupSet = List[zio.aws.ec2.model.StaleSecurityGroup]
  type StoreImageTaskResultSet = List[zio.aws.ec2.model.StoreImageTaskResult]
  type StringList = List[String]
  type SubnetAssociationList = List[zio.aws.ec2.model.SubnetAssociation]
  type SubnetCidrReservationList = List[zio.aws.ec2.model.SubnetCidrReservation]
  type SubnetIdStringList = List[SubnetId]
  type SubnetIpv6CidrBlockAssociationSet =
    List[zio.aws.ec2.model.SubnetIpv6CidrBlockAssociation]
  type SubnetList = List[zio.aws.ec2.model.Subnet]
  type SuccessfulInstanceCreditSpecificationSet =
    List[zio.aws.ec2.model.SuccessfulInstanceCreditSpecificationItem]
  type SuccessfulQueuedPurchaseDeletionSet =
    List[zio.aws.ec2.model.SuccessfulQueuedPurchaseDeletion]
  type SupportedIpAddressTypes = List[zio.aws.ec2.model.ServiceConnectivityType]
  type TagDescriptionList = List[zio.aws.ec2.model.TagDescription]
  type TagList = List[zio.aws.ec2.model.Tag]
  type TagSpecificationList = List[zio.aws.ec2.model.TagSpecification]
  type TargetConfigurationRequestSet =
    List[zio.aws.ec2.model.TargetConfigurationRequest]
  type TargetGroups = List[zio.aws.ec2.model.TargetGroup]
  type TargetNetworkSet = List[zio.aws.ec2.model.TargetNetwork]
  type TargetReservationValueSet =
    List[zio.aws.ec2.model.TargetReservationValue]
  type TerminateConnectionStatusSet =
    List[zio.aws.ec2.model.TerminateConnectionStatus]
  type ThreadsPerCoreList = List[ThreadsPerCore]
  type ThroughResourcesStatementList =
    List[zio.aws.ec2.model.ThroughResourcesStatement]
  type ThroughResourcesStatementRequestList =
    List[zio.aws.ec2.model.ThroughResourcesStatementRequest]
  type TrafficMirrorFilterIdList = List[TrafficMirrorFilterId]
  type TrafficMirrorFilterRuleFieldList =
    List[zio.aws.ec2.model.TrafficMirrorFilterRuleField]
  type TrafficMirrorFilterRuleList =
    List[zio.aws.ec2.model.TrafficMirrorFilterRule]
  type TrafficMirrorFilterSet = List[zio.aws.ec2.model.TrafficMirrorFilter]
  type TrafficMirrorNetworkServiceList =
    List[zio.aws.ec2.model.TrafficMirrorNetworkService]
  type TrafficMirrorSessionFieldList =
    List[zio.aws.ec2.model.TrafficMirrorSessionField]
  type TrafficMirrorSessionIdList = List[TrafficMirrorSessionId]
  type TrafficMirrorSessionSet = List[zio.aws.ec2.model.TrafficMirrorSession]
  type TrafficMirrorTargetIdList = List[TrafficMirrorTargetId]
  type TrafficMirrorTargetSet = List[zio.aws.ec2.model.TrafficMirrorTarget]
  type TransitGatewayAttachmentBgpConfigurationList =
    List[zio.aws.ec2.model.TransitGatewayAttachmentBgpConfiguration]
  type TransitGatewayAttachmentIdStringList = List[TransitGatewayAttachmentId]
  type TransitGatewayAttachmentList =
    List[zio.aws.ec2.model.TransitGatewayAttachment]
  type TransitGatewayAttachmentPropagationList =
    List[zio.aws.ec2.model.TransitGatewayAttachmentPropagation]
  type TransitGatewayCidrBlockStringList = List[String]
  type TransitGatewayConnectList = List[zio.aws.ec2.model.TransitGatewayConnect]
  type TransitGatewayConnectPeerIdStringList = List[TransitGatewayConnectPeerId]
  type TransitGatewayConnectPeerList =
    List[zio.aws.ec2.model.TransitGatewayConnectPeer]
  type TransitGatewayIdStringList = List[TransitGatewayId]
  type TransitGatewayList = List[zio.aws.ec2.model.TransitGateway]
  type TransitGatewayMulticastDomainAssociationList =
    List[zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation]
  type TransitGatewayMulticastDomainIdStringList =
    List[TransitGatewayMulticastDomainId]
  type TransitGatewayMulticastDomainList =
    List[zio.aws.ec2.model.TransitGatewayMulticastDomain]
  type TransitGatewayMulticastGroupList =
    List[zio.aws.ec2.model.TransitGatewayMulticastGroup]
  type TransitGatewayNetworkInterfaceIdList = List[NetworkInterfaceId]
  type TransitGatewayPeeringAttachmentList =
    List[zio.aws.ec2.model.TransitGatewayPeeringAttachment]
  type TransitGatewayPolicyTableAssociationList =
    List[zio.aws.ec2.model.TransitGatewayPolicyTableAssociation]
  type TransitGatewayPolicyTableEntryList =
    List[zio.aws.ec2.model.TransitGatewayPolicyTableEntry]
  type TransitGatewayPolicyTableIdStringList = List[TransitGatewayPolicyTableId]
  type TransitGatewayPolicyTableList =
    List[zio.aws.ec2.model.TransitGatewayPolicyTable]
  type TransitGatewayPrefixListReferenceSet =
    List[zio.aws.ec2.model.TransitGatewayPrefixListReference]
  type TransitGatewayRouteAttachmentList =
    List[zio.aws.ec2.model.TransitGatewayRouteAttachment]
  type TransitGatewayRouteList = List[zio.aws.ec2.model.TransitGatewayRoute]
  type TransitGatewayRouteTableAnnouncementIdStringList =
    List[TransitGatewayRouteTableAnnouncementId]
  type TransitGatewayRouteTableAnnouncementList =
    List[zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement]
  type TransitGatewayRouteTableAssociationList =
    List[zio.aws.ec2.model.TransitGatewayRouteTableAssociation]
  type TransitGatewayRouteTableIdStringList = List[TransitGatewayRouteTableId]
  type TransitGatewayRouteTableList =
    List[zio.aws.ec2.model.TransitGatewayRouteTable]
  type TransitGatewayRouteTablePropagationList =
    List[zio.aws.ec2.model.TransitGatewayRouteTablePropagation]
  type TransitGatewaySubnetIdList = List[SubnetId]
  type TransitGatewayVpcAttachmentList =
    List[zio.aws.ec2.model.TransitGatewayVpcAttachment]
  type TrunkInterfaceAssociationIdList = List[TrunkInterfaceAssociationId]
  type TrunkInterfaceAssociationList =
    List[zio.aws.ec2.model.TrunkInterfaceAssociation]
  type TunnelOptionsList = List[zio.aws.ec2.model.TunnelOption]
  type UnsuccessfulInstanceCreditSpecificationSet =
    List[zio.aws.ec2.model.UnsuccessfulInstanceCreditSpecificationItem]
  type UnsuccessfulItemList = List[zio.aws.ec2.model.UnsuccessfulItem]
  type UnsuccessfulItemSet = List[zio.aws.ec2.model.UnsuccessfulItem]
  type UsageClassTypeList = List[zio.aws.ec2.model.UsageClassType]
  type UserGroupStringList = List[String]
  type UserIdGroupPairList = List[zio.aws.ec2.model.UserIdGroupPair]
  type UserIdGroupPairSet = List[zio.aws.ec2.model.UserIdGroupPair]
  type UserIdStringList = List[String]
  type ValueStringList = List[String]
  type VersionStringList = List[String]
  type VgwTelemetryList = List[zio.aws.ec2.model.VgwTelemetry]
  type VirtualizationTypeList = List[zio.aws.ec2.model.VirtualizationType]
  type VirtualizationTypeSet = List[zio.aws.ec2.model.VirtualizationType]
  type VolumeAttachmentList = List[zio.aws.ec2.model.VolumeAttachment]
  type VolumeIdStringList = List[VolumeId]
  type VolumeList = List[zio.aws.ec2.model.Volume]
  type VolumeModificationList = List[zio.aws.ec2.model.VolumeModification]
  type VolumeStatusActionsList = List[zio.aws.ec2.model.VolumeStatusAction]
  type VolumeStatusAttachmentStatusList =
    List[zio.aws.ec2.model.VolumeStatusAttachmentStatus]
  type VolumeStatusDetailsList = List[zio.aws.ec2.model.VolumeStatusDetails]
  type VolumeStatusEventsList = List[zio.aws.ec2.model.VolumeStatusEvent]
  type VolumeStatusList = List[zio.aws.ec2.model.VolumeStatusItem]
  type VpcAttachmentList = List[zio.aws.ec2.model.VpcAttachment]
  type VpcCidrBlockAssociationSet =
    List[zio.aws.ec2.model.VpcCidrBlockAssociation]
  type VpcClassicLinkIdList = List[VpcId]
  type VpcClassicLinkList = List[zio.aws.ec2.model.VpcClassicLink]
  type VpcEndpointConnectionSet = List[zio.aws.ec2.model.VpcEndpointConnection]
  type VpcEndpointIdList = List[VpcEndpointId]
  type VpcEndpointRouteTableIdList = List[RouteTableId]
  type VpcEndpointSecurityGroupIdList = List[SecurityGroupId]
  type VpcEndpointServiceIdList = List[VpcEndpointServiceId]
  type VpcEndpointSet = List[zio.aws.ec2.model.VpcEndpoint]
  type VpcEndpointSubnetIdList = List[SubnetId]
  type VpcIdStringList = List[VpcId]
  type VpcIpv6CidrBlockAssociationSet =
    List[zio.aws.ec2.model.VpcIpv6CidrBlockAssociation]
  type VpcList = List[zio.aws.ec2.model.Vpc]
  type VpcPeeringConnectionIdList = List[VpcPeeringConnectionId]
  type VpcPeeringConnectionList = List[zio.aws.ec2.model.VpcPeeringConnection]
  type VpnConnectionDeviceTypeList =
    List[zio.aws.ec2.model.VpnConnectionDeviceType]
  type VpnConnectionIdStringList = List[VpnConnectionId]
  type VpnConnectionList = List[zio.aws.ec2.model.VpnConnection]
  type VpnGatewayIdStringList = List[VpnGatewayId]
  type VpnGatewayList = List[zio.aws.ec2.model.VpnGateway]
  type VpnStaticRouteList = List[zio.aws.ec2.model.VpnStaticRoute]
  type VpnTunnelOptionsSpecificationsList =
    List[zio.aws.ec2.model.VpnTunnelOptionsSpecification]
  type ZoneIdStringList = List[String]
  type ZoneNameStringList = List[String]
}
