package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VpnStaticRouteSource {
  def unwrap: software.amazon.awssdk.services.ec2.model.VpnStaticRouteSource
}
object VpnStaticRouteSource {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VpnStaticRouteSource
  ): zio.aws.ec2.model.VpnStaticRouteSource = value match {
    case software.amazon.awssdk.services.ec2.model.VpnStaticRouteSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VpnStaticRouteSource.STATIC =>
      val r = Static
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.VpnStaticRouteSource {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpnStaticRouteSource =
      software.amazon.awssdk.services.ec2.model.VpnStaticRouteSource.UNKNOWN_TO_SDK_VERSION
  }
  case object Static extends zio.aws.ec2.model.VpnStaticRouteSource {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpnStaticRouteSource =
      software.amazon.awssdk.services.ec2.model.VpnStaticRouteSource.STATIC
  }
}
