package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcIpv6CidrBlockAssociation(
    associationId: Optional[String] = Optional.Absent,
    ipv6CidrBlock: Optional[String] = Optional.Absent,
    ipv6CidrBlockState: Optional[zio.aws.ec2.model.VpcCidrBlockState] =
      Optional.Absent,
    networkBorderGroup: Optional[String] = Optional.Absent,
    ipv6Pool: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation = {
    import VpcIpv6CidrBlockAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(ipv6CidrBlock.map(value => value: java.lang.String))(
        _.ipv6CidrBlock
      )
      .optionallyWith(ipv6CidrBlockState.map(value => value.buildAwsValue()))(
        _.ipv6CidrBlockState
      )
      .optionallyWith(networkBorderGroup.map(value => value: java.lang.String))(
        _.networkBorderGroup
      )
      .optionallyWith(ipv6Pool.map(value => value: java.lang.String))(
        _.ipv6Pool
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly =
    zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.wrap(buildAwsValue())
}
object VpcIpv6CidrBlockAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpcIpv6CidrBlockAssociation =
      zio.aws.ec2.model.VpcIpv6CidrBlockAssociation(
        associationId.map(value => value),
        ipv6CidrBlock.map(value => value),
        ipv6CidrBlockState.map(value => value.asEditable),
        networkBorderGroup.map(value => value),
        ipv6Pool.map(value => value)
      )
    def associationId: Optional[String]
    def ipv6CidrBlock: Optional[String]
    def ipv6CidrBlockState
        : Optional[zio.aws.ec2.model.VpcCidrBlockState.ReadOnly]
    def networkBorderGroup: Optional[String]
    def ipv6Pool: Optional[String]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getIpv6CidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
    def getIpv6CidrBlockState
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpcCidrBlockState.ReadOnly] =
      AwsError.unwrapOptionField("ipv6CidrBlockState", ipv6CidrBlockState)
    def getNetworkBorderGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkBorderGroup", networkBorderGroup)
    def getIpv6Pool: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Pool", ipv6Pool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation
  ) extends zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly {
    override val associationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => value: String)
    override val ipv6CidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlock())
      .map(value => value: String)
    override val ipv6CidrBlockState
        : Optional[zio.aws.ec2.model.VpcCidrBlockState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6CidrBlockState())
        .map(value => zio.aws.ec2.model.VpcCidrBlockState.wrap(value))
    override val networkBorderGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkBorderGroup())
      .map(value => value: String)
    override val ipv6Pool: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Pool())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VpcIpv6CidrBlockAssociation
  ): zio.aws.ec2.model.VpcIpv6CidrBlockAssociation.ReadOnly = new Wrapper(impl)
}
