package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrafficMirrorPortRange(
    fromPort: Optional[Integer] = Optional.Absent,
    toPort: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TrafficMirrorPortRange = {
    import TrafficMirrorPortRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TrafficMirrorPortRange
      .builder()
      .optionallyWith(fromPort.map(value => value: java.lang.Integer))(
        _.fromPort
      )
      .optionallyWith(toPort.map(value => value: java.lang.Integer))(_.toPort)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly =
    zio.aws.ec2.model.TrafficMirrorPortRange.wrap(buildAwsValue())
}
object TrafficMirrorPortRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TrafficMirrorPortRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TrafficMirrorPortRange =
      zio.aws.ec2.model.TrafficMirrorPortRange(
        fromPort.map(value => value),
        toPort.map(value => value)
      )
    def fromPort: Optional[Integer]
    def toPort: Optional[Integer]
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorPortRange
  ) extends zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly {
    override val fromPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value => value: Integer)
    override val toPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorPortRange
  ): zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly = new Wrapper(impl)
}
