package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TpmSupportValues {
  def unwrap: software.amazon.awssdk.services.ec2.model.TpmSupportValues
}
object TpmSupportValues {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TpmSupportValues
  ): zio.aws.ec2.model.TpmSupportValues = value match {
    case software.amazon.awssdk.services.ec2.model.TpmSupportValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TpmSupportValues.V2_0 =>
      val r = `v2.0`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.TpmSupportValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TpmSupportValues =
      software.amazon.awssdk.services.ec2.model.TpmSupportValues.UNKNOWN_TO_SDK_VERSION
  }
  case object `v2.0` extends zio.aws.ec2.model.TpmSupportValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TpmSupportValues =
      software.amazon.awssdk.services.ec2.model.TpmSupportValues.V2_0
  }
}
