package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartInstancesResponse(
    startingInstances: Optional[
      Iterable[zio.aws.ec2.model.InstanceStateChange]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StartInstancesResponse = {
    import StartInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StartInstancesResponse
      .builder()
      .optionallyWith(
        startingInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.startingInstances)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.StartInstancesResponse.ReadOnly =
    zio.aws.ec2.model.StartInstancesResponse.wrap(buildAwsValue())
}
object StartInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StartInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StartInstancesResponse =
      zio.aws.ec2.model.StartInstancesResponse(
        startingInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def startingInstances
        : Optional[List[zio.aws.ec2.model.InstanceStateChange.ReadOnly]]
    def getStartingInstances: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceStateChange.ReadOnly
    ]] = AwsError.unwrapOptionField("startingInstances", startingInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StartInstancesResponse
  ) extends zio.aws.ec2.model.StartInstancesResponse.ReadOnly {
    override val startingInstances
        : Optional[List[zio.aws.ec2.model.InstanceStateChange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startingInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceStateChange.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StartInstancesResponse
  ): zio.aws.ec2.model.StartInstancesResponse.ReadOnly = new Wrapper(impl)
}
