package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScheduledInstanceRecurrenceRequest(
    frequency: Optional[String] = Optional.Absent,
    interval: Optional[Integer] = Optional.Absent,
    occurrenceDays: Optional[Iterable[Integer]] = Optional.Absent,
    occurrenceRelativeToEnd: Optional[Boolean] = Optional.Absent,
    occurrenceUnit: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest = {
    import ScheduledInstanceRecurrenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest
      .builder()
      .optionallyWith(frequency.map(value => value: java.lang.String))(
        _.frequency
      )
      .optionallyWith(interval.map(value => value: java.lang.Integer))(
        _.interval
      )
      .optionallyWith(
        occurrenceDays.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.occurrenceDays)
      .optionallyWith(
        occurrenceRelativeToEnd.map(value => value: java.lang.Boolean)
      )(_.occurrenceRelativeToEnd)
      .optionallyWith(occurrenceUnit.map(value => value: java.lang.String))(
        _.occurrenceUnit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest.ReadOnly =
    zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest.wrap(buildAwsValue())
}
object ScheduledInstanceRecurrenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest =
      zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest(
        frequency.map(value => value),
        interval.map(value => value),
        occurrenceDays.map(value => value),
        occurrenceRelativeToEnd.map(value => value),
        occurrenceUnit.map(value => value)
      )
    def frequency: Optional[String]
    def interval: Optional[Integer]
    def occurrenceDays: Optional[List[Integer]]
    def occurrenceRelativeToEnd: Optional[Boolean]
    def occurrenceUnit: Optional[String]
    def getFrequency: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getInterval: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("interval", interval)
    def getOccurrenceDays: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("occurrenceDays", occurrenceDays)
    def getOccurrenceRelativeToEnd: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("occurrenceRelativeToEnd", occurrenceRelativeToEnd)
    def getOccurrenceUnit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("occurrenceUnit", occurrenceUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest
  ) extends zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest.ReadOnly {
    override val frequency: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.frequency())
      .map(value => value: String)
    override val interval: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.interval())
      .map(value => value: Integer)
    override val occurrenceDays: Optional[List[Integer]] = zio.aws.core.internal
      .optionalFromNullable(impl.occurrenceDays())
      .map(value =>
        value.asScala.map { item =>
          item: Integer
        }.toList
      )
    override val occurrenceRelativeToEnd: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.occurrenceRelativeToEnd())
        .map(value => value: Boolean)
    override val occurrenceUnit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.occurrenceUnit())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest
  ): zio.aws.ec2.model.ScheduledInstanceRecurrenceRequest.ReadOnly =
    new Wrapper(impl)
}
