package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceStatement(
    resources: Optional[Iterable[String]] = Optional.Absent,
    resourceTypes: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResourceStatement = {
    import ResourceStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResourceStatement
      .builder()
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResourceStatement.ReadOnly =
    zio.aws.ec2.model.ResourceStatement.wrap(buildAwsValue())
}
object ResourceStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResourceStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResourceStatement =
      zio.aws.ec2.model.ResourceStatement(
        resources.map(value => value),
        resourceTypes.map(value => value)
      )
    def resources: Optional[List[String]]
    def resourceTypes: Optional[List[String]]
    def getResources: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resources", resources)
    def getResourceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResourceStatement
  ) extends zio.aws.ec2.model.ResourceStatement.ReadOnly {
    override val resources: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val resourceTypes: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResourceStatement
  ): zio.aws.ec2.model.ResourceStatement.ReadOnly = new Wrapper(impl)
}
