package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterInstanceEventNotificationAttributesRequest(
    instanceTagAttribute: Optional[
      zio.aws.ec2.model.RegisterInstanceTagAttributeRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest = {
    import RegisterInstanceEventNotificationAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest
      .builder()
      .optionallyWith(instanceTagAttribute.map(value => value.buildAwsValue()))(
        _.instanceTagAttribute
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest.ReadOnly =
    zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest
      .wrap(buildAwsValue())
}
object RegisterInstanceEventNotificationAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest =
      zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest(
        instanceTagAttribute.map(value => value.asEditable)
      )
    def instanceTagAttribute: Optional[
      zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.ReadOnly
    ]
    def getInstanceTagAttribute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.ReadOnly
    ] = AwsError.unwrapOptionField("instanceTagAttribute", instanceTagAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest
  ) extends zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest.ReadOnly {
    override val instanceTagAttribute: Optional[
      zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceTagAttribute())
      .map(value =>
        zio.aws.ec2.model.RegisterInstanceTagAttributeRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest
  ): zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
