package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecurringCharge(
    amount: Optional[Double] = Optional.Absent,
    frequency: Optional[zio.aws.ec2.model.RecurringChargeFrequency] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RecurringCharge = {
    import RecurringCharge.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RecurringCharge
      .builder()
      .optionallyWith(amount.map(value => value: java.lang.Double))(_.amount)
      .optionallyWith(frequency.map(value => value.unwrap))(_.frequency)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RecurringCharge.ReadOnly =
    zio.aws.ec2.model.RecurringCharge.wrap(buildAwsValue())
}
object RecurringCharge {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RecurringCharge
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RecurringCharge =
      zio.aws.ec2.model.RecurringCharge(
        amount.map(value => value),
        frequency.map(value => value)
      )
    def amount: Optional[Double]
    def frequency: Optional[zio.aws.ec2.model.RecurringChargeFrequency]
    def getAmount: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("amount", amount)
    def getFrequency
        : ZIO[Any, AwsError, zio.aws.ec2.model.RecurringChargeFrequency] =
      AwsError.unwrapOptionField("frequency", frequency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RecurringCharge
  ) extends zio.aws.ec2.model.RecurringCharge.ReadOnly {
    override val amount: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.amount())
      .map(value => value: Double)
    override val frequency
        : Optional[zio.aws.ec2.model.RecurringChargeFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frequency())
        .map(value => zio.aws.ec2.model.RecurringChargeFrequency.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RecurringCharge
  ): zio.aws.ec2.model.RecurringCharge.ReadOnly = new Wrapper(impl)
}
