package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait MulticastSupportValue {
  def unwrap: software.amazon.awssdk.services.ec2.model.MulticastSupportValue
}
object MulticastSupportValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.MulticastSupportValue
  ): zio.aws.ec2.model.MulticastSupportValue = value match {
    case software.amazon.awssdk.services.ec2.model.MulticastSupportValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.MulticastSupportValue.ENABLE =>
      val r = enable
      r
    case software.amazon.awssdk.services.ec2.model.MulticastSupportValue.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.MulticastSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.MulticastSupportValue =
      software.amazon.awssdk.services.ec2.model.MulticastSupportValue.UNKNOWN_TO_SDK_VERSION
  }
  case object enable extends zio.aws.ec2.model.MulticastSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.MulticastSupportValue =
      software.amazon.awssdk.services.ec2.model.MulticastSupportValue.ENABLE
  }
  case object disable extends zio.aws.ec2.model.MulticastSupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.MulticastSupportValue =
      software.amazon.awssdk.services.ec2.model.MulticastSupportValue.DISABLE
  }
}
