package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyManagedPrefixListResponse(
    prefixList: Optional[zio.aws.ec2.model.ManagedPrefixList] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListResponse = {
    import ModifyManagedPrefixListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListResponse
      .builder()
      .optionallyWith(prefixList.map(value => value.buildAwsValue()))(
        _.prefixList
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyManagedPrefixListResponse.ReadOnly =
    zio.aws.ec2.model.ModifyManagedPrefixListResponse.wrap(buildAwsValue())
}
object ModifyManagedPrefixListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyManagedPrefixListResponse =
      zio.aws.ec2.model.ModifyManagedPrefixListResponse(
        prefixList.map(value => value.asEditable)
      )
    def prefixList: Optional[zio.aws.ec2.model.ManagedPrefixList.ReadOnly]
    def getPrefixList
        : ZIO[Any, AwsError, zio.aws.ec2.model.ManagedPrefixList.ReadOnly] =
      AwsError.unwrapOptionField("prefixList", prefixList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListResponse
  ) extends zio.aws.ec2.model.ModifyManagedPrefixListResponse.ReadOnly {
    override val prefixList
        : Optional[zio.aws.ec2.model.ManagedPrefixList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixList())
        .map(value => zio.aws.ec2.model.ManagedPrefixList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListResponse
  ): zio.aws.ec2.model.ModifyManagedPrefixListResponse.ReadOnly = new Wrapper(
    impl
  )
}
