package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyIdentityIdFormatRequest(
    principalArn: String,
    resource: String,
    useLongIds: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest = {
    import ModifyIdentityIdFormatRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest
      .builder()
      .principalArn(principalArn: java.lang.String)
      .resource(resource: java.lang.String)
      .useLongIds(useLongIds: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyIdentityIdFormatRequest.ReadOnly =
    zio.aws.ec2.model.ModifyIdentityIdFormatRequest.wrap(buildAwsValue())
}
object ModifyIdentityIdFormatRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyIdentityIdFormatRequest =
      zio.aws.ec2.model
        .ModifyIdentityIdFormatRequest(principalArn, resource, useLongIds)
    def principalArn: String
    def resource: String
    def useLongIds: Boolean
    def getPrincipalArn: ZIO[Any, Nothing, String] = ZIO.succeed(principalArn)
    def getResource: ZIO[Any, Nothing, String] = ZIO.succeed(resource)
    def getUseLongIds: ZIO[Any, Nothing, Boolean] = ZIO.succeed(useLongIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest
  ) extends zio.aws.ec2.model.ModifyIdentityIdFormatRequest.ReadOnly {
    override val principalArn: String = impl.principalArn(): String
    override val resource: String = impl.resource(): String
    override val useLongIds: Boolean = impl.useLongIds(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest
  ): zio.aws.ec2.model.ModifyIdentityIdFormatRequest.ReadOnly = new Wrapper(
    impl
  )
}
