package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, LocalGatewayVirtualInterfaceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LocalGatewayVirtualInterface(
    localGatewayVirtualInterfaceId: Optional[LocalGatewayVirtualInterfaceId] =
      Optional.Absent,
    localGatewayId: Optional[String] = Optional.Absent,
    vlan: Optional[Integer] = Optional.Absent,
    localAddress: Optional[String] = Optional.Absent,
    peerAddress: Optional[String] = Optional.Absent,
    localBgpAsn: Optional[Integer] = Optional.Absent,
    peerBgpAsn: Optional[Integer] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterface = {
    import LocalGatewayVirtualInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterface
      .builder()
      .optionallyWith(
        localGatewayVirtualInterfaceId.map(value =>
          LocalGatewayVirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.localGatewayVirtualInterfaceId)
      .optionallyWith(localGatewayId.map(value => value: java.lang.String))(
        _.localGatewayId
      )
      .optionallyWith(vlan.map(value => value: java.lang.Integer))(_.vlan)
      .optionallyWith(localAddress.map(value => value: java.lang.String))(
        _.localAddress
      )
      .optionallyWith(peerAddress.map(value => value: java.lang.String))(
        _.peerAddress
      )
      .optionallyWith(localBgpAsn.map(value => value: java.lang.Integer))(
        _.localBgpAsn
      )
      .optionallyWith(peerBgpAsn.map(value => value: java.lang.Integer))(
        _.peerBgpAsn
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LocalGatewayVirtualInterface.ReadOnly =
    zio.aws.ec2.model.LocalGatewayVirtualInterface.wrap(buildAwsValue())
}
object LocalGatewayVirtualInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LocalGatewayVirtualInterface =
      zio.aws.ec2.model.LocalGatewayVirtualInterface(
        localGatewayVirtualInterfaceId.map(value => value),
        localGatewayId.map(value => value),
        vlan.map(value => value),
        localAddress.map(value => value),
        peerAddress.map(value => value),
        localBgpAsn.map(value => value),
        peerBgpAsn.map(value => value),
        ownerId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def localGatewayVirtualInterfaceId: Optional[LocalGatewayVirtualInterfaceId]
    def localGatewayId: Optional[String]
    def vlan: Optional[Integer]
    def localAddress: Optional[String]
    def peerAddress: Optional[String]
    def localBgpAsn: Optional[Integer]
    def peerBgpAsn: Optional[Integer]
    def ownerId: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getLocalGatewayVirtualInterfaceId
        : ZIO[Any, AwsError, LocalGatewayVirtualInterfaceId] =
      AwsError.unwrapOptionField(
        "localGatewayVirtualInterfaceId",
        localGatewayVirtualInterfaceId
      )
    def getLocalGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localGatewayId", localGatewayId)
    def getVlan: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vlan", vlan)
    def getLocalAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localAddress", localAddress)
    def getPeerAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("peerAddress", peerAddress)
    def getLocalBgpAsn: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("localBgpAsn", localBgpAsn)
    def getPeerBgpAsn: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("peerBgpAsn", peerBgpAsn)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterface
  ) extends zio.aws.ec2.model.LocalGatewayVirtualInterface.ReadOnly {
    override val localGatewayVirtualInterfaceId
        : Optional[LocalGatewayVirtualInterfaceId] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayVirtualInterfaceId())
      .map(value =>
        zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceId(value)
      )
    override val localGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayId())
      .map(value => value: String)
    override val vlan: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.vlan())
      .map(value => value: Integer)
    override val localAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.localAddress())
      .map(value => value: String)
    override val peerAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.peerAddress())
      .map(value => value: String)
    override val localBgpAsn: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.localBgpAsn())
      .map(value => value: Integer)
    override val peerBgpAsn: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.peerBgpAsn())
      .map(value => value: Integer)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterface
  ): zio.aws.ec2.model.LocalGatewayVirtualInterface.ReadOnly = new Wrapper(impl)
}
