package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchTemplateInstanceMaintenanceOptions(
    autoRecovery: Optional[zio.aws.ec2.model.LaunchTemplateAutoRecoveryState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMaintenanceOptions = {
    import LaunchTemplateInstanceMaintenanceOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMaintenanceOptions
      .builder()
      .optionallyWith(autoRecovery.map(value => value.unwrap))(_.autoRecovery)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptions.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptions
      .wrap(buildAwsValue())
}
object LaunchTemplateInstanceMaintenanceOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMaintenanceOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptions =
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptions(
        autoRecovery.map(value => value)
      )
    def autoRecovery
        : Optional[zio.aws.ec2.model.LaunchTemplateAutoRecoveryState]
    def getAutoRecovery: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateAutoRecoveryState
    ] = AwsError.unwrapOptionField("autoRecovery", autoRecovery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMaintenanceOptions
  ) extends zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptions.ReadOnly {
    override val autoRecovery
        : Optional[zio.aws.ec2.model.LaunchTemplateAutoRecoveryState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoRecovery())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplateAutoRecoveryState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMaintenanceOptions
  ): zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptions.ReadOnly =
    new Wrapper(impl)
}
