package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InterfacePermissionType {
  def unwrap: software.amazon.awssdk.services.ec2.model.InterfacePermissionType
}
object InterfacePermissionType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InterfacePermissionType
  ): zio.aws.ec2.model.InterfacePermissionType = value match {
    case software.amazon.awssdk.services.ec2.model.InterfacePermissionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InterfacePermissionType.INSTANCE_ATTACH =>
      val r = `INSTANCE-ATTACH`
      r
    case software.amazon.awssdk.services.ec2.model.InterfacePermissionType.EIP_ASSOCIATE =>
      val r = `EIP-ASSOCIATE`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InterfacePermissionType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InterfacePermissionType =
      software.amazon.awssdk.services.ec2.model.InterfacePermissionType.UNKNOWN_TO_SDK_VERSION
  }
  case object `INSTANCE-ATTACH`
      extends zio.aws.ec2.model.InterfacePermissionType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InterfacePermissionType =
      software.amazon.awssdk.services.ec2.model.InterfacePermissionType.INSTANCE_ATTACH
  }
  case object `EIP-ASSOCIATE`
      extends zio.aws.ec2.model.InterfacePermissionType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InterfacePermissionType =
      software.amazon.awssdk.services.ec2.model.InterfacePermissionType.EIP_ASSOCIATE
  }
}
