package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceUsage(
    accountId: Optional[String] = Optional.Absent,
    usedInstanceCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceUsage = {
    import InstanceUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceUsage
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(usedInstanceCount.map(value => value: java.lang.Integer))(
        _.usedInstanceCount
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceUsage.ReadOnly =
    zio.aws.ec2.model.InstanceUsage.wrap(buildAwsValue())
}
object InstanceUsage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.InstanceUsage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceUsage =
      zio.aws.ec2.model.InstanceUsage(
        accountId.map(value => value),
        usedInstanceCount.map(value => value)
      )
    def accountId: Optional[String]
    def usedInstanceCount: Optional[Integer]
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getUsedInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("usedInstanceCount", usedInstanceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceUsage
  ) extends zio.aws.ec2.model.InstanceUsage.ReadOnly {
    override val accountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: String)
    override val usedInstanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.usedInstanceCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceUsage
  ): zio.aws.ec2.model.InstanceUsage.ReadOnly = new Wrapper(impl)
}
