package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceMetadataTagsState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.InstanceMetadataTagsState
}
object InstanceMetadataTagsState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceMetadataTagsState
  ): zio.aws.ec2.model.InstanceMetadataTagsState = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceMetadataTagsState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceMetadataTagsState.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.ec2.model.InstanceMetadataTagsState.ENABLED =>
      val r = enabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceMetadataTagsState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMetadataTagsState =
      software.amazon.awssdk.services.ec2.model.InstanceMetadataTagsState.UNKNOWN_TO_SDK_VERSION
  }
  case object disabled extends zio.aws.ec2.model.InstanceMetadataTagsState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMetadataTagsState =
      software.amazon.awssdk.services.ec2.model.InstanceMetadataTagsState.DISABLED
  }
  case object enabled extends zio.aws.ec2.model.InstanceMetadataTagsState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMetadataTagsState =
      software.amazon.awssdk.services.ec2.model.InstanceMetadataTagsState.ENABLED
  }
}
