package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{OfferingId, DedicatedHostId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetHostReservationPurchasePreviewRequest(
    hostIdSet: Iterable[DedicatedHostId],
    offeringId: OfferingId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewRequest = {
    import GetHostReservationPurchasePreviewRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewRequest
      .builder()
      .hostIdSet(hostIdSet.map { item =>
        DedicatedHostId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .offeringId(OfferingId.unwrap(offeringId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetHostReservationPurchasePreviewRequest.ReadOnly =
    zio.aws.ec2.model.GetHostReservationPurchasePreviewRequest
      .wrap(buildAwsValue())
}
object GetHostReservationPurchasePreviewRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetHostReservationPurchasePreviewRequest =
      zio.aws.ec2.model
        .GetHostReservationPurchasePreviewRequest(hostIdSet, offeringId)
    def hostIdSet: List[DedicatedHostId]
    def offeringId: OfferingId
    def getHostIdSet: ZIO[Any, Nothing, List[DedicatedHostId]] =
      ZIO.succeed(hostIdSet)
    def getOfferingId: ZIO[Any, Nothing, OfferingId] = ZIO.succeed(offeringId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewRequest
  ) extends zio.aws.ec2.model.GetHostReservationPurchasePreviewRequest.ReadOnly {
    override val hostIdSet: List[DedicatedHostId] = impl
      .hostIdSet()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.DedicatedHostId(item)
      }
      .toList
    override val offeringId: OfferingId =
      zio.aws.ec2.model.primitives.OfferingId(impl.offeringId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetHostReservationPurchasePreviewRequest
  ): zio.aws.ec2.model.GetHostReservationPurchasePreviewRequest.ReadOnly =
    new Wrapper(impl)
}
