package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetConsoleScreenshotResponse(
    imageData: Optional[String] = Optional.Absent,
    instanceId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotResponse = {
    import GetConsoleScreenshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotResponse
      .builder()
      .optionallyWith(imageData.map(value => value: java.lang.String))(
        _.imageData
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetConsoleScreenshotResponse.ReadOnly =
    zio.aws.ec2.model.GetConsoleScreenshotResponse.wrap(buildAwsValue())
}
object GetConsoleScreenshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetConsoleScreenshotResponse =
      zio.aws.ec2.model.GetConsoleScreenshotResponse(
        imageData.map(value => value),
        instanceId.map(value => value)
      )
    def imageData: Optional[String]
    def instanceId: Optional[String]
    def getImageData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageData", imageData)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotResponse
  ) extends zio.aws.ec2.model.GetConsoleScreenshotResponse.ReadOnly {
    override val imageData: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageData())
      .map(value => value: String)
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetConsoleScreenshotResponse
  ): zio.aws.ec2.model.GetConsoleScreenshotResponse.ReadOnly = new Wrapper(impl)
}
