package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FpgaImageStateCode {
  def unwrap: software.amazon.awssdk.services.ec2.model.FpgaImageStateCode
}
object FpgaImageStateCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FpgaImageStateCode
  ): zio.aws.ec2.model.FpgaImageStateCode = value match {
    case software.amazon.awssdk.services.ec2.model.FpgaImageStateCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FpgaImageStateCode.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.FpgaImageStateCode.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.ec2.model.FpgaImageStateCode.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.FpgaImageStateCode.UNAVAILABLE =>
      val r = unavailable
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.FpgaImageStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FpgaImageStateCode =
      software.amazon.awssdk.services.ec2.model.FpgaImageStateCode.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.FpgaImageStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FpgaImageStateCode =
      software.amazon.awssdk.services.ec2.model.FpgaImageStateCode.PENDING
  }
  case object failed extends zio.aws.ec2.model.FpgaImageStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FpgaImageStateCode =
      software.amazon.awssdk.services.ec2.model.FpgaImageStateCode.FAILED
  }
  case object available extends zio.aws.ec2.model.FpgaImageStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FpgaImageStateCode =
      software.amazon.awssdk.services.ec2.model.FpgaImageStateCode.AVAILABLE
  }
  case object unavailable extends zio.aws.ec2.model.FpgaImageStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FpgaImageStateCode =
      software.amazon.awssdk.services.ec2.model.FpgaImageStateCode.UNAVAILABLE
  }
}
