package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.LaunchTemplateName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FleetLaunchTemplateSpecification(
    launchTemplateId: Optional[String] = Optional.Absent,
    launchTemplateName: Optional[LaunchTemplateName] = Optional.Absent,
    version: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecification = {
    import FleetLaunchTemplateSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecification
      .builder()
      .optionallyWith(launchTemplateId.map(value => value: java.lang.String))(
        _.launchTemplateId
      )
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FleetLaunchTemplateSpecification.ReadOnly =
    zio.aws.ec2.model.FleetLaunchTemplateSpecification.wrap(buildAwsValue())
}
object FleetLaunchTemplateSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetLaunchTemplateSpecification =
      zio.aws.ec2.model.FleetLaunchTemplateSpecification(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        version.map(value => value)
      )
    def launchTemplateId: Optional[String]
    def launchTemplateName: Optional[LaunchTemplateName]
    def version: Optional[String]
    def getLaunchTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecification
  ) extends zio.aws.ec2.model.FleetLaunchTemplateSpecification.ReadOnly {
    override val launchTemplateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateId())
      .map(value => value: String)
    override val launchTemplateName: Optional[LaunchTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateName())
        .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecification
  ): zio.aws.ec2.model.FleetLaunchTemplateSpecification.ReadOnly = new Wrapper(
    impl
  )
}
