package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class EbsInstanceBlockDevice(
    attachTime: Optional[DateTime] = Optional.Absent,
    deleteOnTermination: Optional[Boolean] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.AttachmentStatus] = Optional.Absent,
    volumeId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDevice = {
    import EbsInstanceBlockDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDevice
      .builder()
      .optionallyWith(attachTime.map(value => DateTime.unwrap(value): Instant))(
        _.attachTime
      )
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EbsInstanceBlockDevice.ReadOnly =
    zio.aws.ec2.model.EbsInstanceBlockDevice.wrap(buildAwsValue())
}
object EbsInstanceBlockDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EbsInstanceBlockDevice =
      zio.aws.ec2.model.EbsInstanceBlockDevice(
        attachTime.map(value => value),
        deleteOnTermination.map(value => value),
        status.map(value => value),
        volumeId.map(value => value)
      )
    def attachTime: Optional[DateTime]
    def deleteOnTermination: Optional[Boolean]
    def status: Optional[zio.aws.ec2.model.AttachmentStatus]
    def volumeId: Optional[String]
    def getAttachTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("attachTime", attachTime)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.AttachmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDevice
  ) extends zio.aws.ec2.model.EbsInstanceBlockDevice.ReadOnly {
    override val attachTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.attachTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val deleteOnTermination: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteOnTermination())
      .map(value => value: Boolean)
    override val status: Optional[zio.aws.ec2.model.AttachmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.AttachmentStatus.wrap(value))
    override val volumeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDevice
  ): zio.aws.ec2.model.EbsInstanceBlockDevice.ReadOnly = new Wrapper(impl)
}
