package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVolumesModificationsResponse(
    volumesModifications: Optional[
      Iterable[zio.aws.ec2.model.VolumeModification]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse = {
    import DescribeVolumesModificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse
      .builder()
      .optionallyWith(
        volumesModifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumesModifications)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVolumesModificationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVolumesModificationsResponse.wrap(buildAwsValue())
}
object DescribeVolumesModificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVolumesModificationsResponse =
      zio.aws.ec2.model.DescribeVolumesModificationsResponse(
        volumesModifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def volumesModifications
        : Optional[List[zio.aws.ec2.model.VolumeModification.ReadOnly]]
    def nextToken: Optional[String]
    def getVolumesModifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VolumeModification.ReadOnly
    ]] =
      AwsError.unwrapOptionField("volumesModifications", volumesModifications)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse
  ) extends zio.aws.ec2.model.DescribeVolumesModificationsResponse.ReadOnly {
    override val volumesModifications
        : Optional[List[zio.aws.ec2.model.VolumeModification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumesModifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VolumeModification.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsResponse
  ): zio.aws.ec2.model.DescribeVolumesModificationsResponse.ReadOnly =
    new Wrapper(impl)
}
