package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewayRouteTablesResponse(
    transitGatewayRouteTables: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayRouteTable]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesResponse = {
    import DescribeTransitGatewayRouteTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesResponse
      .builder()
      .optionallyWith(
        transitGatewayRouteTables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayRouteTables)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTransitGatewayRouteTablesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewayRouteTablesResponse
      .wrap(buildAwsValue())
}
object DescribeTransitGatewayRouteTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTransitGatewayRouteTablesResponse =
      zio.aws.ec2.model.DescribeTransitGatewayRouteTablesResponse(
        transitGatewayRouteTables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayRouteTables
        : Optional[List[zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly]]
    def nextToken: Optional[String]
    def getTransitGatewayRouteTables: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayRouteTables",
      transitGatewayRouteTables
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesResponse
  ) extends zio.aws.ec2.model.DescribeTransitGatewayRouteTablesResponse.ReadOnly {
    override val transitGatewayRouteTables
        : Optional[List[zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTables())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TransitGatewayRouteTable.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayRouteTablesResponse
  ): zio.aws.ec2.model.DescribeTransitGatewayRouteTablesResponse.ReadOnly =
    new Wrapper(impl)
}
