package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeKeyPairsResponse(
    keyPairs: Optional[Iterable[zio.aws.ec2.model.KeyPairInfo]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse = {
    import DescribeKeyPairsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse
      .builder()
      .optionallyWith(
        keyPairs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keyPairs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeKeyPairsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeKeyPairsResponse.wrap(buildAwsValue())
}
object DescribeKeyPairsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeKeyPairsResponse =
      zio.aws.ec2.model.DescribeKeyPairsResponse(
        keyPairs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyPairs: Optional[List[zio.aws.ec2.model.KeyPairInfo.ReadOnly]]
    def getKeyPairs
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.KeyPairInfo.ReadOnly]] =
      AwsError.unwrapOptionField("keyPairs", keyPairs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse
  ) extends zio.aws.ec2.model.DescribeKeyPairsResponse.ReadOnly {
    override val keyPairs
        : Optional[List[zio.aws.ec2.model.KeyPairInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPairs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.KeyPairInfo.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse
  ): zio.aws.ec2.model.DescribeKeyPairsResponse.ReadOnly = new Wrapper(impl)
}
