package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeImportImageTasksResponse(
    importImageTasks: Optional[Iterable[zio.aws.ec2.model.ImportImageTask]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse = {
    import DescribeImportImageTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse
      .builder()
      .optionallyWith(
        importImageTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.importImageTasks)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeImportImageTasksResponse.ReadOnly =
    zio.aws.ec2.model.DescribeImportImageTasksResponse.wrap(buildAwsValue())
}
object DescribeImportImageTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImportImageTasksResponse =
      zio.aws.ec2.model.DescribeImportImageTasksResponse(
        importImageTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def importImageTasks
        : Optional[List[zio.aws.ec2.model.ImportImageTask.ReadOnly]]
    def nextToken: Optional[String]
    def getImportImageTasks
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ImportImageTask.ReadOnly]] =
      AwsError.unwrapOptionField("importImageTasks", importImageTasks)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse
  ) extends zio.aws.ec2.model.DescribeImportImageTasksResponse.ReadOnly {
    override val importImageTasks
        : Optional[List[zio.aws.ec2.model.ImportImageTask.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importImageTasks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ImportImageTask.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImportImageTasksResponse
  ): zio.aws.ec2.model.DescribeImportImageTasksResponse.ReadOnly = new Wrapper(
    impl
  )
}
