package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayPolicyTableResponse(
    transitGatewayPolicyTable: Optional[
      zio.aws.ec2.model.TransitGatewayPolicyTable
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableResponse = {
    import DeleteTransitGatewayPolicyTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableResponse
      .builder()
      .optionallyWith(
        transitGatewayPolicyTable.map(value => value.buildAwsValue())
      )(_.transitGatewayPolicyTable)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayPolicyTableResponse.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayPolicyTableResponse
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayPolicyTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTransitGatewayPolicyTableResponse =
      zio.aws.ec2.model.DeleteTransitGatewayPolicyTableResponse(
        transitGatewayPolicyTable.map(value => value.asEditable)
      )
    def transitGatewayPolicyTable
        : Optional[zio.aws.ec2.model.TransitGatewayPolicyTable.ReadOnly]
    def getTransitGatewayPolicyTable: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPolicyTable.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayPolicyTable",
      transitGatewayPolicyTable
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableResponse
  ) extends zio.aws.ec2.model.DeleteTransitGatewayPolicyTableResponse.ReadOnly {
    override val transitGatewayPolicyTable
        : Optional[zio.aws.ec2.model.TransitGatewayPolicyTable.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayPolicyTable())
        .map(value => zio.aws.ec2.model.TransitGatewayPolicyTable.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayPolicyTableResponse
  ): zio.aws.ec2.model.DeleteTransitGatewayPolicyTableResponse.ReadOnly =
    new Wrapper(impl)
}
