package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SecurityGroupId,
  SubnetId,
  RouteTableId,
  VpcId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointRequest(
    vpcEndpointType: Optional[zio.aws.ec2.model.VpcEndpointType] =
      Optional.Absent,
    vpcId: VpcId,
    serviceName: String,
    policyDocument: Optional[String] = Optional.Absent,
    routeTableIds: Optional[Iterable[RouteTableId]] = Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    ipAddressType: Optional[zio.aws.ec2.model.IpAddressType] = Optional.Absent,
    dnsOptions: Optional[zio.aws.ec2.model.DnsOptionsSpecification] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    privateDnsEnabled: Optional[Boolean] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest = {
    import CreateVpcEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest
      .builder()
      .optionallyWith(vpcEndpointType.map(value => value.unwrap))(
        _.vpcEndpointType
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .serviceName(serviceName: java.lang.String)
      .optionallyWith(policyDocument.map(value => value: java.lang.String))(
        _.policyDocument
      )
      .optionallyWith(
        routeTableIds.map(value =>
          value.map { item =>
            RouteTableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.routeTableIds)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(dnsOptions.map(value => value.buildAwsValue()))(
        _.dnsOptions
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(privateDnsEnabled.map(value => value: java.lang.Boolean))(
        _.privateDnsEnabled
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpcEndpointRequest.ReadOnly =
    zio.aws.ec2.model.CreateVpcEndpointRequest.wrap(buildAwsValue())
}
object CreateVpcEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpcEndpointRequest =
      zio.aws.ec2.model.CreateVpcEndpointRequest(
        vpcEndpointType.map(value => value),
        vpcId,
        serviceName,
        policyDocument.map(value => value),
        routeTableIds.map(value => value),
        subnetIds.map(value => value),
        securityGroupIds.map(value => value),
        ipAddressType.map(value => value),
        dnsOptions.map(value => value.asEditable),
        clientToken.map(value => value),
        privateDnsEnabled.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vpcEndpointType: Optional[zio.aws.ec2.model.VpcEndpointType]
    def vpcId: VpcId
    def serviceName: String
    def policyDocument: Optional[String]
    def routeTableIds: Optional[List[RouteTableId]]
    def subnetIds: Optional[List[SubnetId]]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def ipAddressType: Optional[zio.aws.ec2.model.IpAddressType]
    def dnsOptions: Optional[zio.aws.ec2.model.DnsOptionsSpecification.ReadOnly]
    def clientToken: Optional[String]
    def privateDnsEnabled: Optional[Boolean]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getVpcEndpointType
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpcEndpointType] =
      AwsError.unwrapOptionField("vpcEndpointType", vpcEndpointType)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getServiceName: ZIO[Any, Nothing, String] = ZIO.succeed(serviceName)
    def getPolicyDocument: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
    def getRouteTableIds: ZIO[Any, AwsError, List[RouteTableId]] =
      AwsError.unwrapOptionField("routeTableIds", routeTableIds)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getIpAddressType: ZIO[Any, AwsError, zio.aws.ec2.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getDnsOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DnsOptionsSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("dnsOptions", dnsOptions)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getPrivateDnsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privateDnsEnabled", privateDnsEnabled)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest
  ) extends zio.aws.ec2.model.CreateVpcEndpointRequest.ReadOnly {
    override val vpcEndpointType: Optional[zio.aws.ec2.model.VpcEndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpointType())
        .map(value => zio.aws.ec2.model.VpcEndpointType.wrap(value))
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val serviceName: String = impl.serviceName(): String
    override val policyDocument: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyDocument())
      .map(value => value: String)
    override val routeTableIds: Optional[List[RouteTableId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeTableIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.RouteTableId(item)
          }.toList
        )
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val ipAddressType: Optional[zio.aws.ec2.model.IpAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipAddressType())
        .map(value => zio.aws.ec2.model.IpAddressType.wrap(value))
    override val dnsOptions
        : Optional[zio.aws.ec2.model.DnsOptionsSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsOptions())
        .map(value => zio.aws.ec2.model.DnsOptionsSpecification.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val privateDnsEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsEnabled())
      .map(value => value: Boolean)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointRequest
  ): zio.aws.ec2.model.CreateVpcEndpointRequest.ReadOnly = new Wrapper(impl)
}
