package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateRouteTableResponse(
    routeTable: Optional[zio.aws.ec2.model.RouteTable] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateRouteTableResponse = {
    import CreateRouteTableResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateRouteTableResponse
      .builder()
      .optionallyWith(routeTable.map(value => value.buildAwsValue()))(
        _.routeTable
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateRouteTableResponse.ReadOnly =
    zio.aws.ec2.model.CreateRouteTableResponse.wrap(buildAwsValue())
}
object CreateRouteTableResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateRouteTableResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateRouteTableResponse =
      zio.aws.ec2.model
        .CreateRouteTableResponse(routeTable.map(value => value.asEditable))
    def routeTable: Optional[zio.aws.ec2.model.RouteTable.ReadOnly]
    def getRouteTable
        : ZIO[Any, AwsError, zio.aws.ec2.model.RouteTable.ReadOnly] =
      AwsError.unwrapOptionField("routeTable", routeTable)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateRouteTableResponse
  ) extends zio.aws.ec2.model.CreateRouteTableResponse.ReadOnly {
    override val routeTable: Optional[zio.aws.ec2.model.RouteTable.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeTable())
        .map(value => zio.aws.ec2.model.RouteTable.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateRouteTableResponse
  ): zio.aws.ec2.model.CreateRouteTableResponse.ReadOnly = new Wrapper(impl)
}
