package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Ipv4PoolCoipId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateCoipCidrRequest(
    cidr: String,
    coipPoolId: Ipv4PoolCoipId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCoipCidrRequest = {
    import CreateCoipCidrRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCoipCidrRequest
      .builder()
      .cidr(cidr: java.lang.String)
      .coipPoolId(Ipv4PoolCoipId.unwrap(coipPoolId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateCoipCidrRequest.ReadOnly =
    zio.aws.ec2.model.CreateCoipCidrRequest.wrap(buildAwsValue())
}
object CreateCoipCidrRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCoipCidrRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCoipCidrRequest =
      zio.aws.ec2.model.CreateCoipCidrRequest(cidr, coipPoolId)
    def cidr: String
    def coipPoolId: Ipv4PoolCoipId
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
    def getCoipPoolId: ZIO[Any, Nothing, Ipv4PoolCoipId] =
      ZIO.succeed(coipPoolId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCoipCidrRequest
  ) extends zio.aws.ec2.model.CreateCoipCidrRequest.ReadOnly {
    override val cidr: String = impl.cidr(): String
    override val coipPoolId: Ipv4PoolCoipId =
      zio.aws.ec2.model.primitives.Ipv4PoolCoipId(impl.coipPoolId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCoipCidrRequest
  ): zio.aws.ec2.model.CreateCoipCidrRequest.ReadOnly = new Wrapper(impl)
}
