package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CapacityReservationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CapacityReservationTarget(
    capacityReservationId: Optional[CapacityReservationId] = Optional.Absent,
    capacityReservationResourceGroupArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CapacityReservationTarget = {
    import CapacityReservationTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CapacityReservationTarget
      .builder()
      .optionallyWith(
        capacityReservationId.map(value =>
          CapacityReservationId.unwrap(value): java.lang.String
        )
      )(_.capacityReservationId)
      .optionallyWith(
        capacityReservationResourceGroupArn.map(value =>
          value: java.lang.String
        )
      )(_.capacityReservationResourceGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CapacityReservationTarget.ReadOnly =
    zio.aws.ec2.model.CapacityReservationTarget.wrap(buildAwsValue())
}
object CapacityReservationTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CapacityReservationTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CapacityReservationTarget =
      zio.aws.ec2.model.CapacityReservationTarget(
        capacityReservationId.map(value => value),
        capacityReservationResourceGroupArn.map(value => value)
      )
    def capacityReservationId: Optional[CapacityReservationId]
    def capacityReservationResourceGroupArn: Optional[String]
    def getCapacityReservationId: ZIO[Any, AwsError, CapacityReservationId] =
      AwsError.unwrapOptionField("capacityReservationId", capacityReservationId)
    def getCapacityReservationResourceGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "capacityReservationResourceGroupArn",
        capacityReservationResourceGroupArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationTarget
  ) extends zio.aws.ec2.model.CapacityReservationTarget.ReadOnly {
    override val capacityReservationId: Optional[CapacityReservationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationId())
        .map(value => zio.aws.ec2.model.primitives.CapacityReservationId(value))
    override val capacityReservationResourceGroupArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationResourceGroupArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CapacityReservationTarget
  ): zio.aws.ec2.model.CapacityReservationTarget.ReadOnly = new Wrapper(impl)
}
